/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputEncryptedChat;
import telegram4j.tl.InputEncryptedFile;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.UploadEncryptedFile;

public final class ImmutableUploadEncryptedFile
implements UploadEncryptedFile {
    private final int identifier;
    private final InputEncryptedChat peer;
    private final InputEncryptedFile file;

    private ImmutableUploadEncryptedFile(InputEncryptedChat peer, InputEncryptedFile file) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.file = Objects.requireNonNull(file, "file");
        this.identifier = UploadEncryptedFile.super.identifier();
    }

    private ImmutableUploadEncryptedFile(Builder builder) {
        this.peer = builder.peer;
        this.file = builder.file;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UploadEncryptedFile.super.identifier();
    }

    private ImmutableUploadEncryptedFile(int identifier, InputEncryptedChat peer, InputEncryptedFile file) {
        this.identifier = identifier;
        this.peer = peer;
        this.file = file;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputEncryptedChat peer() {
        return this.peer;
    }

    @Override
    public InputEncryptedFile file() {
        return this.file;
    }

    public final ImmutableUploadEncryptedFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUploadEncryptedFile(value, this.peer, this.file);
    }

    public final ImmutableUploadEncryptedFile withPeer(InputEncryptedChat value) {
        if (this.peer == value) {
            return this;
        }
        InputEncryptedChat newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUploadEncryptedFile(this.identifier, newValue, this.file);
    }

    public final ImmutableUploadEncryptedFile withFile(InputEncryptedFile value) {
        if (this.file == value) {
            return this;
        }
        InputEncryptedFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableUploadEncryptedFile(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUploadEncryptedFile && this.equalTo(0, (ImmutableUploadEncryptedFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableUploadEncryptedFile another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "UploadEncryptedFile{identifier=" + this.identifier + ", peer=" + this.peer + ", file=" + this.file + "}";
    }

    public static ImmutableUploadEncryptedFile of(InputEncryptedChat peer, InputEncryptedFile file) {
        return new ImmutableUploadEncryptedFile(peer, file);
    }

    public static ImmutableUploadEncryptedFile copyOf(UploadEncryptedFile instance) {
        if (instance instanceof ImmutableUploadEncryptedFile) {
            return (ImmutableUploadEncryptedFile)instance;
        }
        return ImmutableUploadEncryptedFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_FILE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputEncryptedChat peer;
        private InputEncryptedFile file;

        private Builder() {
        }

        public final Builder from(UploadEncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UploadEncryptedFile instance;
            long bits = 0L;
            if (object instanceof UploadEncryptedFile) {
                instance = (UploadEncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.file(instance.file());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputEncryptedChat peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder file(InputEncryptedFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUploadEncryptedFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUploadEncryptedFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build UploadEncryptedFile, some of required attributes are not set " + attributes;
        }
    }
}

