/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.messages.UploadImportedMedia;

public final class ImmutableUploadImportedMedia
implements UploadImportedMedia {
    private final int identifier;
    private final InputPeer peer;
    private final long importId;
    private final String fileName;
    private final InputMedia media;

    private ImmutableUploadImportedMedia(InputPeer peer, long importId, String fileName, InputMedia media) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.importId = importId;
        this.fileName = Objects.requireNonNull(fileName, "fileName");
        this.media = Objects.requireNonNull(media, "media");
        this.identifier = UploadImportedMedia.super.identifier();
    }

    private ImmutableUploadImportedMedia(Builder builder) {
        this.peer = builder.peer;
        this.importId = builder.importId;
        this.fileName = builder.fileName;
        this.media = builder.media;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UploadImportedMedia.super.identifier();
    }

    private ImmutableUploadImportedMedia(int identifier, InputPeer peer, long importId, String fileName, InputMedia media) {
        this.identifier = identifier;
        this.peer = peer;
        this.importId = importId;
        this.fileName = fileName;
        this.media = media;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public long importId() {
        return this.importId;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public InputMedia media() {
        return this.media;
    }

    public final ImmutableUploadImportedMedia withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUploadImportedMedia(value, this.peer, this.importId, this.fileName, this.media);
    }

    public final ImmutableUploadImportedMedia withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUploadImportedMedia(this.identifier, newValue, this.importId, this.fileName, this.media);
    }

    public final ImmutableUploadImportedMedia withImportId(long value) {
        if (this.importId == value) {
            return this;
        }
        return new ImmutableUploadImportedMedia(this.identifier, this.peer, value, this.fileName, this.media);
    }

    public final ImmutableUploadImportedMedia withFileName(String value) {
        String newValue = Objects.requireNonNull(value, "fileName");
        if (this.fileName.equals(newValue)) {
            return this;
        }
        return new ImmutableUploadImportedMedia(this.identifier, this.peer, this.importId, newValue, this.media);
    }

    public final ImmutableUploadImportedMedia withMedia(InputMedia value) {
        if (this.media == value) {
            return this;
        }
        InputMedia newValue = Objects.requireNonNull(value, "media");
        return new ImmutableUploadImportedMedia(this.identifier, this.peer, this.importId, this.fileName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUploadImportedMedia && this.equalTo(0, (ImmutableUploadImportedMedia)another);
    }

    private boolean equalTo(int synthetic, ImmutableUploadImportedMedia another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.importId == another.importId && this.fileName.equals(another.fileName) && this.media.equals(another.media);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.importId);
        h += (h << 5) + this.fileName.hashCode();
        h += (h << 5) + this.media.hashCode();
        return h;
    }

    public String toString() {
        return "UploadImportedMedia{identifier=" + this.identifier + ", peer=" + this.peer + ", importId=" + this.importId + ", fileName=" + this.fileName + ", media=" + this.media + "}";
    }

    public static ImmutableUploadImportedMedia of(InputPeer peer, long importId, String fileName, InputMedia media) {
        return new ImmutableUploadImportedMedia(peer, importId, fileName, media);
    }

    public static ImmutableUploadImportedMedia copyOf(UploadImportedMedia instance) {
        if (instance instanceof ImmutableUploadImportedMedia) {
            return (ImmutableUploadImportedMedia)instance;
        }
        return ImmutableUploadImportedMedia.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_IMPORT_ID = 2L;
        private static final long INIT_BIT_FILE_NAME = 4L;
        private static final long INIT_BIT_MEDIA = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private long importId;
        private String fileName;
        private InputMedia media;

        private Builder() {
        }

        public final Builder from(UploadImportedMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UploadImportedMedia instance;
            long bits = 0L;
            if (object instanceof UploadImportedMedia) {
                instance = (UploadImportedMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fileName(instance.fileName());
                this.importId(instance.importId());
                this.media(instance.media());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder importId(long importId) {
            this.importId = importId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fileName(String fileName) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder media(InputMedia media) {
            this.media = Objects.requireNonNull(media, "media");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUploadImportedMedia build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUploadImportedMedia(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("importId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fileName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("media");
            }
            return "Cannot build UploadImportedMedia, some of required attributes are not set " + attributes;
        }
    }
}

