/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.mtproto.DestroySession;

public final class ImmutableDestroySession
implements DestroySession {
    private final int identifier;
    private final long sessionId;

    private ImmutableDestroySession(long sessionId) {
        this.sessionId = sessionId;
        this.identifier = DestroySession.super.identifier();
    }

    private ImmutableDestroySession(Builder builder) {
        this.sessionId = builder.sessionId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DestroySession.super.identifier();
    }

    private ImmutableDestroySession(int identifier, long sessionId) {
        this.identifier = identifier;
        this.sessionId = sessionId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    public final ImmutableDestroySession withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDestroySession(value, this.sessionId);
    }

    public final ImmutableDestroySession withSessionId(long value) {
        if (this.sessionId == value) {
            return this;
        }
        return new ImmutableDestroySession(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDestroySession && this.equalTo(0, (ImmutableDestroySession)another);
    }

    private boolean equalTo(int synthetic, ImmutableDestroySession another) {
        return this.identifier == another.identifier && this.sessionId == another.sessionId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.sessionId);
        return h;
    }

    public String toString() {
        return "DestroySession{identifier=" + this.identifier + ", sessionId=" + this.sessionId + "}";
    }

    public static ImmutableDestroySession of(long sessionId) {
        return new ImmutableDestroySession(sessionId);
    }

    public static ImmutableDestroySession copyOf(DestroySession instance) {
        if (instance instanceof ImmutableDestroySession) {
            return (ImmutableDestroySession)instance;
        }
        return ImmutableDestroySession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SESSION_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long sessionId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DestroySession instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DestroySession) {
                instance = (DestroySession)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.sessionId(instance.sessionId());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sessionId(long sessionId) {
            this.sessionId = sessionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDestroySession build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDestroySession(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sessionId");
            }
            return "Cannot build DestroySession, some of required attributes are not set " + attributes;
        }
    }
}

