/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.mtproto.Ping;

public final class ImmutablePing
implements Ping {
    private final int identifier;
    private final long pingId;

    private ImmutablePing(long pingId) {
        this.pingId = pingId;
        this.identifier = Ping.super.identifier();
    }

    private ImmutablePing(Builder builder) {
        this.pingId = builder.pingId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Ping.super.identifier();
    }

    private ImmutablePing(int identifier, long pingId) {
        this.identifier = identifier;
        this.pingId = pingId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long pingId() {
        return this.pingId;
    }

    public final ImmutablePing withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePing(value, this.pingId);
    }

    public final ImmutablePing withPingId(long value) {
        if (this.pingId == value) {
            return this;
        }
        return new ImmutablePing(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePing && this.equalTo(0, (ImmutablePing)another);
    }

    private boolean equalTo(int synthetic, ImmutablePing another) {
        return this.identifier == another.identifier && this.pingId == another.pingId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.pingId);
        return h;
    }

    public String toString() {
        return "Ping{identifier=" + this.identifier + ", pingId=" + this.pingId + "}";
    }

    public static ImmutablePing of(long pingId) {
        return new ImmutablePing(pingId);
    }

    public static ImmutablePing copyOf(Ping instance) {
        if (instance instanceof ImmutablePing) {
            return (ImmutablePing)instance;
        }
        return ImmutablePing.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PING_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long pingId;

        private Builder() {
        }

        public final Builder from(Ping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Ping instance;
            long bits = 0L;
            if (object instanceof Ping) {
                instance = (Ping)object;
                this.pingId(instance.pingId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pingId(long pingId) {
            this.pingId = pingId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePing build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePing(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pingId");
            }
            return "Cannot build Ping, some of required attributes are not set " + attributes;
        }
    }
}

