/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.mtproto.PingDelayDisconnect;

public final class ImmutablePingDelayDisconnect
implements PingDelayDisconnect {
    private final int identifier;
    private final long pingId;
    private final int disconnectDelay;

    private ImmutablePingDelayDisconnect(long pingId, int disconnectDelay) {
        this.pingId = pingId;
        this.disconnectDelay = disconnectDelay;
        this.identifier = PingDelayDisconnect.super.identifier();
    }

    private ImmutablePingDelayDisconnect(Builder builder) {
        this.pingId = builder.pingId;
        this.disconnectDelay = builder.disconnectDelay;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PingDelayDisconnect.super.identifier();
    }

    private ImmutablePingDelayDisconnect(int identifier, long pingId, int disconnectDelay) {
        this.identifier = identifier;
        this.pingId = pingId;
        this.disconnectDelay = disconnectDelay;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long pingId() {
        return this.pingId;
    }

    @Override
    public int disconnectDelay() {
        return this.disconnectDelay;
    }

    public final ImmutablePingDelayDisconnect withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePingDelayDisconnect(value, this.pingId, this.disconnectDelay);
    }

    public final ImmutablePingDelayDisconnect withPingId(long value) {
        if (this.pingId == value) {
            return this;
        }
        return new ImmutablePingDelayDisconnect(this.identifier, value, this.disconnectDelay);
    }

    public final ImmutablePingDelayDisconnect withDisconnectDelay(int value) {
        if (this.disconnectDelay == value) {
            return this;
        }
        return new ImmutablePingDelayDisconnect(this.identifier, this.pingId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePingDelayDisconnect && this.equalTo(0, (ImmutablePingDelayDisconnect)another);
    }

    private boolean equalTo(int synthetic, ImmutablePingDelayDisconnect another) {
        return this.identifier == another.identifier && this.pingId == another.pingId && this.disconnectDelay == another.disconnectDelay;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.pingId);
        h += (h << 5) + this.disconnectDelay;
        return h;
    }

    public String toString() {
        return "PingDelayDisconnect{identifier=" + this.identifier + ", pingId=" + this.pingId + ", disconnectDelay=" + this.disconnectDelay + "}";
    }

    public static ImmutablePingDelayDisconnect of(long pingId, int disconnectDelay) {
        return new ImmutablePingDelayDisconnect(pingId, disconnectDelay);
    }

    public static ImmutablePingDelayDisconnect copyOf(PingDelayDisconnect instance) {
        if (instance instanceof ImmutablePingDelayDisconnect) {
            return (ImmutablePingDelayDisconnect)instance;
        }
        return ImmutablePingDelayDisconnect.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PING_ID = 1L;
        private static final long INIT_BIT_DISCONNECT_DELAY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long pingId;
        private int disconnectDelay;

        private Builder() {
        }

        public final Builder from(PingDelayDisconnect instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PingDelayDisconnect instance;
            long bits = 0L;
            if (object instanceof PingDelayDisconnect) {
                instance = (PingDelayDisconnect)object;
                this.pingId(instance.pingId());
                this.disconnectDelay(instance.disconnectDelay());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pingId(long pingId) {
            this.pingId = pingId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder disconnectDelay(int disconnectDelay) {
            this.disconnectDelay = disconnectDelay;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePingDelayDisconnect build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePingDelayDisconnect(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pingId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("disconnectDelay");
            }
            return "Cannot build PingDelayDisconnect, some of required attributes are not set " + attributes;
        }
    }
}

