/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.mtproto.ReqDHParams;

public final class ImmutableReqDHParams
implements ReqDHParams {
    private final int identifier;
    private final ByteBuf nonce;
    private final ByteBuf serverNonce;
    private final ByteBuf p;
    private final ByteBuf q;
    private final long publicKeyFingerprint;
    private final ByteBuf encryptedData;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReqDHParams(long publicKeyFingerprint) {
        this.publicKeyFingerprint = publicKeyFingerprint;
        this.nonce = null;
        this.serverNonce = null;
        this.p = null;
        this.q = null;
        this.encryptedData = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableReqDHParams(Builder builder) {
        this.nonce = builder.nonce_build();
        this.serverNonce = builder.serverNonce_build();
        this.p = builder.p_build();
        this.q = builder.q_build();
        this.publicKeyFingerprint = builder.publicKeyFingerprint;
        this.encryptedData = builder.encryptedData_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableReqDHParams(int identifier, ByteBuf nonce, ByteBuf serverNonce, ByteBuf p, ByteBuf q, long publicKeyFingerprint, ByteBuf encryptedData) {
        this.identifier = identifier;
        this.nonce = nonce;
        this.serverNonce = serverNonce;
        this.p = p;
        this.q = q;
        this.publicKeyFingerprint = publicKeyFingerprint;
        this.encryptedData = encryptedData;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ReqDHParams.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf nonce() {
        return this.nonce.duplicate();
    }

    @Override
    public ByteBuf serverNonce() {
        return this.serverNonce.duplicate();
    }

    @Override
    public ByteBuf p() {
        return this.p.duplicate();
    }

    @Override
    public ByteBuf q() {
        return this.q.duplicate();
    }

    @Override
    public long publicKeyFingerprint() {
        return this.publicKeyFingerprint;
    }

    @Override
    public ByteBuf encryptedData() {
        return this.encryptedData.duplicate();
    }

    public final ImmutableReqDHParams withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReqDHParams(value, this.nonce, this.serverNonce, this.p, this.q, this.publicKeyFingerprint, this.encryptedData);
    }

    public ImmutableReqDHParams withNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.nonce == newValue) {
            return this;
        }
        return new ImmutableReqDHParams(this.identifier, newValue, this.serverNonce, this.p, this.q, this.publicKeyFingerprint, this.encryptedData);
    }

    public ImmutableReqDHParams withServerNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.serverNonce == newValue) {
            return this;
        }
        return new ImmutableReqDHParams(this.identifier, this.nonce, newValue, this.p, this.q, this.publicKeyFingerprint, this.encryptedData);
    }

    public ImmutableReqDHParams withP(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.p == newValue) {
            return this;
        }
        return new ImmutableReqDHParams(this.identifier, this.nonce, this.serverNonce, newValue, this.q, this.publicKeyFingerprint, this.encryptedData);
    }

    public ImmutableReqDHParams withQ(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.q == newValue) {
            return this;
        }
        return new ImmutableReqDHParams(this.identifier, this.nonce, this.serverNonce, this.p, newValue, this.publicKeyFingerprint, this.encryptedData);
    }

    public final ImmutableReqDHParams withPublicKeyFingerprint(long value) {
        if (this.publicKeyFingerprint == value) {
            return this;
        }
        return new ImmutableReqDHParams(this.identifier, this.nonce, this.serverNonce, this.p, this.q, value, this.encryptedData);
    }

    public ImmutableReqDHParams withEncryptedData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.encryptedData == newValue) {
            return this;
        }
        return new ImmutableReqDHParams(this.identifier, this.nonce, this.serverNonce, this.p, this.q, this.publicKeyFingerprint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReqDHParams && this.equalTo(0, (ImmutableReqDHParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableReqDHParams another) {
        return this.identifier == another.identifier && this.nonce().equals((Object)another.nonce()) && this.serverNonce().equals((Object)another.serverNonce()) && this.p().equals((Object)another.p()) && this.q().equals((Object)another.q()) && this.publicKeyFingerprint == another.publicKeyFingerprint && this.encryptedData().equals((Object)another.encryptedData());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.serverNonce().hashCode();
        h += (h << 5) + this.p().hashCode();
        h += (h << 5) + this.q().hashCode();
        h += (h << 5) + Long.hashCode(this.publicKeyFingerprint);
        h += (h << 5) + this.encryptedData().hashCode();
        return h;
    }

    public String toString() {
        return "ReqDHParams{identifier=" + this.identifier + ", nonce=" + ByteBufUtil.hexDump((ByteBuf)this.nonce) + ", serverNonce=" + ByteBufUtil.hexDump((ByteBuf)this.serverNonce) + ", p=" + ByteBufUtil.hexDump((ByteBuf)this.p) + ", q=" + ByteBufUtil.hexDump((ByteBuf)this.q) + ", publicKeyFingerprint=" + this.publicKeyFingerprint + ", encryptedData=" + ByteBufUtil.hexDump((ByteBuf)this.encryptedData) + "}";
    }

    public static ImmutableReqDHParams of(long publicKeyFingerprint) {
        return new ImmutableReqDHParams(publicKeyFingerprint);
    }

    public static ImmutableReqDHParams copyOf(ReqDHParams instance) {
        if (instance instanceof ImmutableReqDHParams) {
            return (ImmutableReqDHParams)instance;
        }
        return ImmutableReqDHParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PUBLIC_KEY_FINGERPRINT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf nonce_value = null;
        private ByteBuf serverNonce_value = null;
        private ByteBuf p_value = null;
        private ByteBuf q_value = null;
        private ByteBuf encryptedData_value = null;
        private int identifier;
        private long publicKeyFingerprint;

        private Builder() {
        }

        public final Builder from(ReqDHParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReqDHParams instance;
            long bits = 0L;
            if (object instanceof ReqDHParams) {
                instance = (ReqDHParams)object;
                this.p(instance.p());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.q(instance.q());
                this.publicKeyFingerprint(instance.publicKeyFingerprint());
                this.encryptedData(instance.encryptedData());
                this.serverNonce(instance.serverNonce());
                this.nonce(instance.nonce());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder nonce(ByteBuf value) {
            this.nonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder serverNonce(ByteBuf value) {
            this.serverNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder p(ByteBuf value) {
            this.p_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder q(ByteBuf value) {
            this.q_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder publicKeyFingerprint(long publicKeyFingerprint) {
            this.publicKeyFingerprint = publicKeyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder encryptedData(ByteBuf value) {
            this.encryptedData_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableReqDHParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReqDHParams(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("publicKeyFingerprint");
            }
            return "Cannot build ReqDHParams, some of required attributes are not set " + attributes;
        }

        private ByteBuf nonce_build() {
            return Objects.requireNonNull(this.nonce_value);
        }

        private ByteBuf serverNonce_build() {
            return Objects.requireNonNull(this.serverNonce_value);
        }

        private ByteBuf p_build() {
            return Objects.requireNonNull(this.p_value);
        }

        private ByteBuf q_build() {
            return Objects.requireNonNull(this.q_value);
        }

        private ByteBuf encryptedData_build() {
            return Objects.requireNonNull(this.encryptedData_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableReqDHParams.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ReqDHParams, attribute initializers form cycle " + attributes;
        }
    }
}

