/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.mtproto.RpcDropAnswer;

public final class ImmutableRpcDropAnswer
implements RpcDropAnswer {
    private final int identifier;
    private final long reqMsgId;

    private ImmutableRpcDropAnswer(long reqMsgId) {
        this.reqMsgId = reqMsgId;
        this.identifier = RpcDropAnswer.super.identifier();
    }

    private ImmutableRpcDropAnswer(Builder builder) {
        this.reqMsgId = builder.reqMsgId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RpcDropAnswer.super.identifier();
    }

    private ImmutableRpcDropAnswer(int identifier, long reqMsgId) {
        this.identifier = identifier;
        this.reqMsgId = reqMsgId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long reqMsgId() {
        return this.reqMsgId;
    }

    public final ImmutableRpcDropAnswer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRpcDropAnswer(value, this.reqMsgId);
    }

    public final ImmutableRpcDropAnswer withReqMsgId(long value) {
        if (this.reqMsgId == value) {
            return this;
        }
        return new ImmutableRpcDropAnswer(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRpcDropAnswer && this.equalTo(0, (ImmutableRpcDropAnswer)another);
    }

    private boolean equalTo(int synthetic, ImmutableRpcDropAnswer another) {
        return this.identifier == another.identifier && this.reqMsgId == another.reqMsgId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.reqMsgId);
        return h;
    }

    public String toString() {
        return "RpcDropAnswer{identifier=" + this.identifier + ", reqMsgId=" + this.reqMsgId + "}";
    }

    public static ImmutableRpcDropAnswer of(long reqMsgId) {
        return new ImmutableRpcDropAnswer(reqMsgId);
    }

    public static ImmutableRpcDropAnswer copyOf(RpcDropAnswer instance) {
        if (instance instanceof ImmutableRpcDropAnswer) {
            return (ImmutableRpcDropAnswer)instance;
        }
        return ImmutableRpcDropAnswer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REQ_MSG_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long reqMsgId;

        private Builder() {
        }

        public final Builder from(RpcDropAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RpcDropAnswer instance;
            long bits = 0L;
            if (object instanceof RpcDropAnswer) {
                instance = (RpcDropAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reqMsgId(instance.reqMsgId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder reqMsgId(long reqMsgId) {
            this.reqMsgId = reqMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRpcDropAnswer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRpcDropAnswer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reqMsgId");
            }
            return "Cannot build RpcDropAnswer, some of required attributes are not set " + attributes;
        }
    }
}

