/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.mtproto.SetClientDHParams;

public final class ImmutableSetClientDHParams
implements SetClientDHParams {
    private final int identifier;
    private final ByteBuf nonce;
    private final ByteBuf serverNonce;
    private final ByteBuf encryptedData;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetClientDHParams(Builder builder) {
        this.nonce = builder.nonce_build();
        this.serverNonce = builder.serverNonce_build();
        this.encryptedData = builder.encryptedData_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSetClientDHParams(int identifier, ByteBuf nonce, ByteBuf serverNonce, ByteBuf encryptedData) {
        this.identifier = identifier;
        this.nonce = nonce;
        this.serverNonce = serverNonce;
        this.encryptedData = encryptedData;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetClientDHParams.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf nonce() {
        return this.nonce.duplicate();
    }

    @Override
    public ByteBuf serverNonce() {
        return this.serverNonce.duplicate();
    }

    @Override
    public ByteBuf encryptedData() {
        return this.encryptedData.duplicate();
    }

    public final ImmutableSetClientDHParams withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetClientDHParams(value, this.nonce, this.serverNonce, this.encryptedData);
    }

    public ImmutableSetClientDHParams withNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.nonce == newValue) {
            return this;
        }
        return new ImmutableSetClientDHParams(this.identifier, newValue, this.serverNonce, this.encryptedData);
    }

    public ImmutableSetClientDHParams withServerNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.serverNonce == newValue) {
            return this;
        }
        return new ImmutableSetClientDHParams(this.identifier, this.nonce, newValue, this.encryptedData);
    }

    public ImmutableSetClientDHParams withEncryptedData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.encryptedData == newValue) {
            return this;
        }
        return new ImmutableSetClientDHParams(this.identifier, this.nonce, this.serverNonce, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetClientDHParams && this.equalTo(0, (ImmutableSetClientDHParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetClientDHParams another) {
        return this.identifier == another.identifier && this.nonce().equals((Object)another.nonce()) && this.serverNonce().equals((Object)another.serverNonce()) && this.encryptedData().equals((Object)another.encryptedData());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.serverNonce().hashCode();
        h += (h << 5) + this.encryptedData().hashCode();
        return h;
    }

    public String toString() {
        return "SetClientDHParams{identifier=" + this.identifier + ", nonce=" + ByteBufUtil.hexDump((ByteBuf)this.nonce) + ", serverNonce=" + ByteBufUtil.hexDump((ByteBuf)this.serverNonce) + ", encryptedData=" + ByteBufUtil.hexDump((ByteBuf)this.encryptedData) + "}";
    }

    public static ImmutableSetClientDHParams copyOf(SetClientDHParams instance) {
        if (instance instanceof ImmutableSetClientDHParams) {
            return (ImmutableSetClientDHParams)instance;
        }
        return ImmutableSetClientDHParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf nonce_value = null;
        private ByteBuf serverNonce_value = null;
        private ByteBuf encryptedData_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetClientDHParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetClientDHParams) {
                instance = (SetClientDHParams)object;
                this.encryptedData(instance.encryptedData());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.serverNonce(instance.serverNonce());
                this.nonce(instance.nonce());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder nonce(ByteBuf value) {
            this.nonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder serverNonce(ByteBuf value) {
            this.serverNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder encryptedData(ByteBuf value) {
            this.encryptedData_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSetClientDHParams build() {
            return new ImmutableSetClientDHParams(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf nonce_build() {
            return Objects.requireNonNull(this.nonce_value);
        }

        private ByteBuf serverNonce_build() {
            return Objects.requireNonNull(this.serverNonce_value);
        }

        private ByteBuf encryptedData_build() {
            return Objects.requireNonNull(this.encryptedData_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetClientDHParams.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SetClientDHParams, attribute initializers form cycle " + attributes;
        }
    }
}

