/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStorePaymentPurpose;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.AssignAppStoreTransaction;

public final class ImmutableAssignAppStoreTransaction
implements AssignAppStoreTransaction {
    private final int identifier;
    private final ByteBuf receipt;
    private final InputStorePaymentPurpose purpose;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAssignAppStoreTransaction(InputStorePaymentPurpose purpose) {
        this.purpose = Objects.requireNonNull(purpose, "purpose");
        this.receipt = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableAssignAppStoreTransaction(Builder builder) {
        this.receipt = builder.receipt_build();
        this.purpose = builder.purpose;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableAssignAppStoreTransaction(int identifier, ByteBuf receipt, InputStorePaymentPurpose purpose) {
        this.identifier = identifier;
        this.receipt = receipt;
        this.purpose = purpose;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AssignAppStoreTransaction.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf receipt() {
        return this.receipt.duplicate();
    }

    @Override
    public InputStorePaymentPurpose purpose() {
        return this.purpose;
    }

    public final ImmutableAssignAppStoreTransaction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAssignAppStoreTransaction(value, this.receipt, this.purpose);
    }

    public ImmutableAssignAppStoreTransaction withReceipt(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.receipt == newValue) {
            return this;
        }
        return new ImmutableAssignAppStoreTransaction(this.identifier, newValue, this.purpose);
    }

    public final ImmutableAssignAppStoreTransaction withPurpose(InputStorePaymentPurpose value) {
        if (this.purpose == value) {
            return this;
        }
        InputStorePaymentPurpose newValue = Objects.requireNonNull(value, "purpose");
        return new ImmutableAssignAppStoreTransaction(this.identifier, this.receipt, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAssignAppStoreTransaction && this.equalTo(0, (ImmutableAssignAppStoreTransaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableAssignAppStoreTransaction another) {
        return this.identifier == another.identifier && this.receipt().equals((Object)another.receipt()) && this.purpose.equals(another.purpose);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.receipt().hashCode();
        h += (h << 5) + this.purpose.hashCode();
        return h;
    }

    public String toString() {
        return "AssignAppStoreTransaction{identifier=" + this.identifier + ", receipt=" + ByteBufUtil.hexDump((ByteBuf)this.receipt) + ", purpose=" + this.purpose + "}";
    }

    public static ImmutableAssignAppStoreTransaction of(InputStorePaymentPurpose purpose) {
        return new ImmutableAssignAppStoreTransaction(purpose);
    }

    public static ImmutableAssignAppStoreTransaction copyOf(AssignAppStoreTransaction instance) {
        if (instance instanceof ImmutableAssignAppStoreTransaction) {
            return (ImmutableAssignAppStoreTransaction)instance;
        }
        return ImmutableAssignAppStoreTransaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PURPOSE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf receipt_value = null;
        private int identifier;
        private InputStorePaymentPurpose purpose;

        private Builder() {
        }

        public final Builder from(AssignAppStoreTransaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AssignAppStoreTransaction instance;
            long bits = 0L;
            if (object instanceof AssignAppStoreTransaction) {
                instance = (AssignAppStoreTransaction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.purpose(instance.purpose());
                this.receipt(instance.receipt());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder receipt(ByteBuf value) {
            this.receipt_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder purpose(InputStorePaymentPurpose purpose) {
            this.purpose = Objects.requireNonNull(purpose, "purpose");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableAssignAppStoreTransaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAssignAppStoreTransaction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("purpose");
            }
            return "Cannot build AssignAppStoreTransaction, some of required attributes are not set " + attributes;
        }

        private ByteBuf receipt_build() {
            return Objects.requireNonNull(this.receipt_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAssignAppStoreTransaction.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build AssignAppStoreTransaction, attribute initializers form cycle " + attributes;
        }
    }
}

