/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputStorePaymentPurpose;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.AssignPlayMarketTransaction;

public final class ImmutableAssignPlayMarketTransaction
implements AssignPlayMarketTransaction {
    private final int identifier;
    private final DataJSON receipt;
    private final InputStorePaymentPurpose purpose;

    private ImmutableAssignPlayMarketTransaction(DataJSON receipt, InputStorePaymentPurpose purpose) {
        this.receipt = Objects.requireNonNull(receipt, "receipt");
        this.purpose = Objects.requireNonNull(purpose, "purpose");
        this.identifier = AssignPlayMarketTransaction.super.identifier();
    }

    private ImmutableAssignPlayMarketTransaction(Builder builder) {
        this.receipt = builder.receipt;
        this.purpose = builder.purpose;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AssignPlayMarketTransaction.super.identifier();
    }

    private ImmutableAssignPlayMarketTransaction(int identifier, DataJSON receipt, InputStorePaymentPurpose purpose) {
        this.identifier = identifier;
        this.receipt = receipt;
        this.purpose = purpose;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public DataJSON receipt() {
        return this.receipt;
    }

    @Override
    public InputStorePaymentPurpose purpose() {
        return this.purpose;
    }

    public final ImmutableAssignPlayMarketTransaction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAssignPlayMarketTransaction(value, this.receipt, this.purpose);
    }

    public final ImmutableAssignPlayMarketTransaction withReceipt(DataJSON value) {
        if (this.receipt == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "receipt");
        return new ImmutableAssignPlayMarketTransaction(this.identifier, newValue, this.purpose);
    }

    public final ImmutableAssignPlayMarketTransaction withPurpose(InputStorePaymentPurpose value) {
        if (this.purpose == value) {
            return this;
        }
        InputStorePaymentPurpose newValue = Objects.requireNonNull(value, "purpose");
        return new ImmutableAssignPlayMarketTransaction(this.identifier, this.receipt, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAssignPlayMarketTransaction && this.equalTo(0, (ImmutableAssignPlayMarketTransaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableAssignPlayMarketTransaction another) {
        return this.identifier == another.identifier && this.receipt.equals(another.receipt) && this.purpose.equals(another.purpose);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.receipt.hashCode();
        h += (h << 5) + this.purpose.hashCode();
        return h;
    }

    public String toString() {
        return "AssignPlayMarketTransaction{identifier=" + this.identifier + ", receipt=" + this.receipt + ", purpose=" + this.purpose + "}";
    }

    public static ImmutableAssignPlayMarketTransaction of(DataJSON receipt, InputStorePaymentPurpose purpose) {
        return new ImmutableAssignPlayMarketTransaction(receipt, purpose);
    }

    public static ImmutableAssignPlayMarketTransaction copyOf(AssignPlayMarketTransaction instance) {
        if (instance instanceof ImmutableAssignPlayMarketTransaction) {
            return (ImmutableAssignPlayMarketTransaction)instance;
        }
        return ImmutableAssignPlayMarketTransaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RECEIPT = 1L;
        private static final long INIT_BIT_PURPOSE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private DataJSON receipt;
        private InputStorePaymentPurpose purpose;

        private Builder() {
        }

        public final Builder from(AssignPlayMarketTransaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AssignPlayMarketTransaction instance;
            long bits = 0L;
            if (object instanceof AssignPlayMarketTransaction) {
                instance = (AssignPlayMarketTransaction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.purpose(instance.purpose());
                this.receipt(instance.receipt());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder receipt(DataJSON receipt) {
            this.receipt = Objects.requireNonNull(receipt, "receipt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder purpose(InputStorePaymentPurpose purpose) {
            this.purpose = Objects.requireNonNull(purpose, "purpose");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAssignPlayMarketTransaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAssignPlayMarketTransaction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("receipt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("purpose");
            }
            return "Cannot build AssignPlayMarketTransaction, some of required attributes are not set " + attributes;
        }
    }
}

