/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStorePaymentPurpose;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.CanPurchasePremium;

public final class ImmutableCanPurchasePremium
implements CanPurchasePremium {
    private final int identifier;
    private final InputStorePaymentPurpose purpose;

    private ImmutableCanPurchasePremium(InputStorePaymentPurpose purpose) {
        this.purpose = Objects.requireNonNull(purpose, "purpose");
        this.identifier = CanPurchasePremium.super.identifier();
    }

    private ImmutableCanPurchasePremium(Builder builder) {
        this.purpose = builder.purpose;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CanPurchasePremium.super.identifier();
    }

    private ImmutableCanPurchasePremium(int identifier, InputStorePaymentPurpose purpose) {
        this.identifier = identifier;
        this.purpose = purpose;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStorePaymentPurpose purpose() {
        return this.purpose;
    }

    public final ImmutableCanPurchasePremium withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCanPurchasePremium(value, this.purpose);
    }

    public final ImmutableCanPurchasePremium withPurpose(InputStorePaymentPurpose value) {
        if (this.purpose == value) {
            return this;
        }
        InputStorePaymentPurpose newValue = Objects.requireNonNull(value, "purpose");
        return new ImmutableCanPurchasePremium(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCanPurchasePremium && this.equalTo(0, (ImmutableCanPurchasePremium)another);
    }

    private boolean equalTo(int synthetic, ImmutableCanPurchasePremium another) {
        return this.identifier == another.identifier && this.purpose.equals(another.purpose);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.purpose.hashCode();
        return h;
    }

    public String toString() {
        return "CanPurchasePremium{identifier=" + this.identifier + ", purpose=" + this.purpose + "}";
    }

    public static ImmutableCanPurchasePremium of(InputStorePaymentPurpose purpose) {
        return new ImmutableCanPurchasePremium(purpose);
    }

    public static ImmutableCanPurchasePremium copyOf(CanPurchasePremium instance) {
        if (instance instanceof ImmutableCanPurchasePremium) {
            return (ImmutableCanPurchasePremium)instance;
        }
        return ImmutableCanPurchasePremium.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PURPOSE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputStorePaymentPurpose purpose;

        private Builder() {
        }

        public final Builder from(CanPurchasePremium instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CanPurchasePremium instance;
            long bits = 0L;
            if (object instanceof CanPurchasePremium) {
                instance = (CanPurchasePremium)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.purpose(instance.purpose());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder purpose(InputStorePaymentPurpose purpose) {
            this.purpose = Objects.requireNonNull(purpose, "purpose");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCanPurchasePremium build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCanPurchasePremium(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("purpose");
            }
            return "Cannot build CanPurchasePremium, some of required attributes are not set " + attributes;
        }
    }
}

