/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.ClearSavedInfo;

public final class ImmutableClearSavedInfo
implements ClearSavedInfo {
    private final int identifier;
    private final int flags;
    private final boolean credentials;
    private final boolean info;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableClearSavedInfo INSTANCE = ImmutableClearSavedInfo.validate(new ImmutableClearSavedInfo());

    private ImmutableClearSavedInfo() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.credentials = this.initShim.credentials();
        this.info = this.initShim.info();
        this.initShim = null;
    }

    private ImmutableClearSavedInfo(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.credentialsIsSet()) {
            this.initShim.credentials(builder.credentials);
        }
        if (builder.infoIsSet()) {
            this.initShim.info(builder.info);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.credentials = this.initShim.credentials();
        this.info = this.initShim.info();
        this.initShim = null;
    }

    private ImmutableClearSavedInfo(int identifier, int flags, boolean credentials, boolean info) {
        this.identifier = identifier;
        this.flags = flags;
        this.credentials = credentials;
        this.info = info;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ClearSavedInfo.super.identifier();
    }

    private int flagsInitialize() {
        return ClearSavedInfo.super.flags();
    }

    private boolean credentialsInitialize() {
        return ClearSavedInfo.super.credentials();
    }

    private boolean infoInitialize() {
        return ClearSavedInfo.super.info();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean credentials() {
        InitShim shim = this.initShim;
        return shim != null ? shim.credentials() : this.credentials;
    }

    @Override
    public boolean info() {
        InitShim shim = this.initShim;
        return shim != null ? shim.info() : this.info;
    }

    public final ImmutableClearSavedInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableClearSavedInfo.validate(new ImmutableClearSavedInfo(value, this.flags, this.credentials, this.info));
    }

    public final ImmutableClearSavedInfo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableClearSavedInfo.validate(new ImmutableClearSavedInfo(this.identifier, value, this.credentials, this.info));
    }

    public final ImmutableClearSavedInfo withCredentials(boolean value) {
        if (this.credentials == value) {
            return this;
        }
        return ImmutableClearSavedInfo.validate(new ImmutableClearSavedInfo(this.identifier, this.flags, value, this.info));
    }

    public final ImmutableClearSavedInfo withInfo(boolean value) {
        if (this.info == value) {
            return this;
        }
        return ImmutableClearSavedInfo.validate(new ImmutableClearSavedInfo(this.identifier, this.flags, this.credentials, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClearSavedInfo && this.equalTo(0, (ImmutableClearSavedInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableClearSavedInfo another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.credentials == another.credentials && this.info == another.info;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.credentials);
        h += (h << 5) + Boolean.hashCode(this.info);
        return h;
    }

    public String toString() {
        return "ClearSavedInfo{identifier=" + this.identifier + ", flags=" + this.flags + ", credentials=" + this.credentials + ", info=" + this.info + "}";
    }

    public static ImmutableClearSavedInfo of() {
        return INSTANCE;
    }

    private static ImmutableClearSavedInfo validate(ImmutableClearSavedInfo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableClearSavedInfo copyOf(ClearSavedInfo instance) {
        if (instance instanceof ImmutableClearSavedInfo) {
            return (ImmutableClearSavedInfo)instance;
        }
        return ImmutableClearSavedInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CREDENTIALS = 4L;
        private static final long OPT_BIT_INFO = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean credentials;
        private boolean info;

        private Builder() {
        }

        public final Builder from(ClearSavedInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ClearSavedInfo instance;
            long bits = 0L;
            if (object instanceof ClearSavedInfo) {
                instance = (ClearSavedInfo)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.credentials(instance.credentials());
                this.info(instance.info());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder credentials(boolean credentials) {
            this.credentials = credentials;
            this.optBits |= 4L;
            return this;
        }

        public final Builder info(boolean info) {
            this.info = info;
            this.optBits |= 8L;
            return this;
        }

        public ImmutableClearSavedInfo build() {
            return ImmutableClearSavedInfo.validate(new ImmutableClearSavedInfo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean credentialsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean infoIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte credentialsBuildStage = 0;
        private boolean credentials;
        private byte infoBuildStage = 0;
        private boolean info;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableClearSavedInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableClearSavedInfo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean credentials() {
            if (this.credentialsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.credentialsBuildStage == 0) {
                this.credentialsBuildStage = (byte)-1;
                this.credentials = ImmutableClearSavedInfo.this.credentialsInitialize();
                this.credentialsBuildStage = 1;
            }
            return this.credentials;
        }

        void credentials(boolean credentials) {
            this.credentials = credentials;
            this.credentialsBuildStage = 1;
        }

        boolean info() {
            if (this.infoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.infoBuildStage == 0) {
                this.infoBuildStage = (byte)-1;
                this.info = ImmutableClearSavedInfo.this.infoInitialize();
                this.infoBuildStage = 1;
            }
            return this.info;
        }

        void info(boolean info) {
            this.info = info;
            this.infoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.credentialsBuildStage == -1) {
                attributes.add("credentials");
            }
            if (this.infoBuildStage == -1) {
                attributes.add("info");
            }
            return "Cannot build ClearSavedInfo, attribute initializers form cycle " + attributes;
        }
    }
}

