/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMedia;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.ExportInvoice;

public final class ImmutableExportInvoice
implements ExportInvoice {
    private final int identifier;
    private final InputMedia invoiceMedia;

    private ImmutableExportInvoice(InputMedia invoiceMedia) {
        this.invoiceMedia = Objects.requireNonNull(invoiceMedia, "invoiceMedia");
        this.identifier = ExportInvoice.super.identifier();
    }

    private ImmutableExportInvoice(Builder builder) {
        this.invoiceMedia = builder.invoiceMedia;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ExportInvoice.super.identifier();
    }

    private ImmutableExportInvoice(int identifier, InputMedia invoiceMedia) {
        this.identifier = identifier;
        this.invoiceMedia = invoiceMedia;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputMedia invoiceMedia() {
        return this.invoiceMedia;
    }

    public final ImmutableExportInvoice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportInvoice(value, this.invoiceMedia);
    }

    public final ImmutableExportInvoice withInvoiceMedia(InputMedia value) {
        if (this.invoiceMedia == value) {
            return this;
        }
        InputMedia newValue = Objects.requireNonNull(value, "invoiceMedia");
        return new ImmutableExportInvoice(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportInvoice && this.equalTo(0, (ImmutableExportInvoice)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportInvoice another) {
        return this.identifier == another.identifier && this.invoiceMedia.equals(another.invoiceMedia);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.invoiceMedia.hashCode();
        return h;
    }

    public String toString() {
        return "ExportInvoice{identifier=" + this.identifier + ", invoiceMedia=" + this.invoiceMedia + "}";
    }

    public static ImmutableExportInvoice of(InputMedia invoiceMedia) {
        return new ImmutableExportInvoice(invoiceMedia);
    }

    public static ImmutableExportInvoice copyOf(ExportInvoice instance) {
        if (instance instanceof ImmutableExportInvoice) {
            return (ImmutableExportInvoice)instance;
        }
        return ImmutableExportInvoice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INVOICE_MEDIA = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputMedia invoiceMedia;

        private Builder() {
        }

        public final Builder from(ExportInvoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExportInvoice instance;
            long bits = 0L;
            if (object instanceof ExportInvoice) {
                instance = (ExportInvoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.invoiceMedia(instance.invoiceMedia());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder invoiceMedia(InputMedia invoiceMedia) {
            this.invoiceMedia = Objects.requireNonNull(invoiceMedia, "invoiceMedia");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExportInvoice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportInvoice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("invoiceMedia");
            }
            return "Cannot build ExportInvoice, some of required attributes are not set " + attributes;
        }
    }
}

