/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.GetBankCardData;

public final class ImmutableGetBankCardData
implements GetBankCardData {
    private final int identifier;
    private final String number;

    private ImmutableGetBankCardData(String number) {
        this.number = Objects.requireNonNull(number, "number");
        this.identifier = GetBankCardData.super.identifier();
    }

    private ImmutableGetBankCardData(Builder builder) {
        this.number = builder.number;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetBankCardData.super.identifier();
    }

    private ImmutableGetBankCardData(int identifier, String number) {
        this.identifier = identifier;
        this.number = number;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String number() {
        return this.number;
    }

    public final ImmutableGetBankCardData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetBankCardData(value, this.number);
    }

    public final ImmutableGetBankCardData withNumber(String value) {
        String newValue = Objects.requireNonNull(value, "number");
        if (this.number.equals(newValue)) {
            return this;
        }
        return new ImmutableGetBankCardData(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetBankCardData && this.equalTo(0, (ImmutableGetBankCardData)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetBankCardData another) {
        return this.identifier == another.identifier && this.number.equals(another.number);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.number.hashCode();
        return h;
    }

    public String toString() {
        return "GetBankCardData{identifier=" + this.identifier + ", number=" + this.number + "}";
    }

    public static ImmutableGetBankCardData of(String number) {
        return new ImmutableGetBankCardData(number);
    }

    public static ImmutableGetBankCardData copyOf(GetBankCardData instance) {
        if (instance instanceof ImmutableGetBankCardData) {
            return (ImmutableGetBankCardData)instance;
        }
        return ImmutableGetBankCardData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NUMBER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String number;

        private Builder() {
        }

        public final Builder from(GetBankCardData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetBankCardData instance;
            long bits = 0L;
            if (object instanceof GetBankCardData) {
                instance = (GetBankCardData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.number(instance.number());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder number(String number) {
            this.number = Objects.requireNonNull(number, "number");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetBankCardData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetBankCardData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("number");
            }
            return "Cannot build GetBankCardData, some of required attributes are not set " + attributes;
        }
    }
}

