/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputInvoice;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.GetPaymentForm;

public final class ImmutableGetPaymentForm
implements GetPaymentForm {
    private final int identifier;
    private final int flags;
    private final InputInvoice invoice;
    @Nullable
    private final DataJSON themeParams;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGetPaymentForm(InputInvoice invoice) {
        this.invoice = Objects.requireNonNull(invoice, "invoice");
        this.themeParams = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetPaymentForm(Builder builder) {
        this.invoice = builder.invoice;
        this.themeParams = builder.themeParams;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGetPaymentForm(int identifier, int flags, InputInvoice invoice, @Nullable DataJSON themeParams) {
        this.identifier = identifier;
        this.flags = flags;
        this.invoice = invoice;
        this.themeParams = themeParams;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetPaymentForm.super.identifier();
    }

    private int flagsInitialize() {
        return GetPaymentForm.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputInvoice invoice() {
        return this.invoice;
    }

    @Override
    @Nullable
    public DataJSON themeParams() {
        return this.themeParams;
    }

    public final ImmutableGetPaymentForm withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetPaymentForm(value, this.flags, this.invoice, this.themeParams);
    }

    public final ImmutableGetPaymentForm withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGetPaymentForm(this.identifier, value, this.invoice, this.themeParams);
    }

    public final ImmutableGetPaymentForm withInvoice(InputInvoice value) {
        if (this.invoice == value) {
            return this;
        }
        InputInvoice newValue = Objects.requireNonNull(value, "invoice");
        return new ImmutableGetPaymentForm(this.identifier, this.flags, newValue, this.themeParams);
    }

    public final ImmutableGetPaymentForm withThemeParams(@Nullable DataJSON value) {
        if (this.themeParams == value) {
            return this;
        }
        return new ImmutableGetPaymentForm(this.identifier, this.flags, this.invoice, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetPaymentForm && this.equalTo(0, (ImmutableGetPaymentForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetPaymentForm another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.invoice.equals(another.invoice) && Objects.equals(this.themeParams, another.themeParams);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.invoice.hashCode();
        h += (h << 5) + Objects.hashCode(this.themeParams);
        return h;
    }

    public String toString() {
        return "GetPaymentForm{identifier=" + this.identifier + ", flags=" + this.flags + ", invoice=" + this.invoice + ", themeParams=" + this.themeParams + "}";
    }

    public static ImmutableGetPaymentForm of(InputInvoice invoice) {
        return new ImmutableGetPaymentForm(invoice);
    }

    public static ImmutableGetPaymentForm copyOf(GetPaymentForm instance) {
        if (instance instanceof ImmutableGetPaymentForm) {
            return (ImmutableGetPaymentForm)instance;
        }
        return ImmutableGetPaymentForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INVOICE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputInvoice invoice;
        private DataJSON themeParams;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetPaymentForm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetPaymentForm) {
                DataJSON themeParamsValue;
                instance = (GetPaymentForm)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((themeParamsValue = instance.themeParams()) != null) {
                    this.themeParams(themeParamsValue);
                }
                this.invoice(instance.invoice());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder invoice(InputInvoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder themeParams(@Nullable DataJSON themeParams) {
            this.themeParams = themeParams;
            return this;
        }

        public ImmutableGetPaymentForm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetPaymentForm(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("invoice");
            }
            return "Cannot build GetPaymentForm, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetPaymentForm.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetPaymentForm.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GetPaymentForm, attribute initializers form cycle " + attributes;
        }
    }
}

