/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.RequestRecurringPayment;

public final class ImmutableRequestRecurringPayment
implements RequestRecurringPayment {
    private final int identifier;
    private final InputUser userId;
    private final String recurringInitCharge;
    private final InputMedia invoiceMedia;

    private ImmutableRequestRecurringPayment(InputUser userId, String recurringInitCharge, InputMedia invoiceMedia) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.recurringInitCharge = Objects.requireNonNull(recurringInitCharge, "recurringInitCharge");
        this.invoiceMedia = Objects.requireNonNull(invoiceMedia, "invoiceMedia");
        this.identifier = RequestRecurringPayment.super.identifier();
    }

    private ImmutableRequestRecurringPayment(Builder builder) {
        this.userId = builder.userId;
        this.recurringInitCharge = builder.recurringInitCharge;
        this.invoiceMedia = builder.invoiceMedia;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RequestRecurringPayment.super.identifier();
    }

    private ImmutableRequestRecurringPayment(int identifier, InputUser userId, String recurringInitCharge, InputMedia invoiceMedia) {
        this.identifier = identifier;
        this.userId = userId;
        this.recurringInitCharge = recurringInitCharge;
        this.invoiceMedia = invoiceMedia;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public String recurringInitCharge() {
        return this.recurringInitCharge;
    }

    @Override
    public InputMedia invoiceMedia() {
        return this.invoiceMedia;
    }

    public final ImmutableRequestRecurringPayment withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRequestRecurringPayment(value, this.userId, this.recurringInitCharge, this.invoiceMedia);
    }

    public final ImmutableRequestRecurringPayment withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableRequestRecurringPayment(this.identifier, newValue, this.recurringInitCharge, this.invoiceMedia);
    }

    public final ImmutableRequestRecurringPayment withRecurringInitCharge(String value) {
        String newValue = Objects.requireNonNull(value, "recurringInitCharge");
        if (this.recurringInitCharge.equals(newValue)) {
            return this;
        }
        return new ImmutableRequestRecurringPayment(this.identifier, this.userId, newValue, this.invoiceMedia);
    }

    public final ImmutableRequestRecurringPayment withInvoiceMedia(InputMedia value) {
        if (this.invoiceMedia == value) {
            return this;
        }
        InputMedia newValue = Objects.requireNonNull(value, "invoiceMedia");
        return new ImmutableRequestRecurringPayment(this.identifier, this.userId, this.recurringInitCharge, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestRecurringPayment && this.equalTo(0, (ImmutableRequestRecurringPayment)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequestRecurringPayment another) {
        return this.identifier == another.identifier && this.userId.equals(another.userId) && this.recurringInitCharge.equals(another.recurringInitCharge) && this.invoiceMedia.equals(another.invoiceMedia);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.recurringInitCharge.hashCode();
        h += (h << 5) + this.invoiceMedia.hashCode();
        return h;
    }

    public String toString() {
        return "RequestRecurringPayment{identifier=" + this.identifier + ", userId=" + this.userId + ", recurringInitCharge=" + this.recurringInitCharge + ", invoiceMedia=" + this.invoiceMedia + "}";
    }

    public static ImmutableRequestRecurringPayment of(InputUser userId, String recurringInitCharge, InputMedia invoiceMedia) {
        return new ImmutableRequestRecurringPayment(userId, recurringInitCharge, invoiceMedia);
    }

    public static ImmutableRequestRecurringPayment copyOf(RequestRecurringPayment instance) {
        if (instance instanceof ImmutableRequestRecurringPayment) {
            return (ImmutableRequestRecurringPayment)instance;
        }
        return ImmutableRequestRecurringPayment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_RECURRING_INIT_CHARGE = 2L;
        private static final long INIT_BIT_INVOICE_MEDIA = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputUser userId;
        private String recurringInitCharge;
        private InputMedia invoiceMedia;

        private Builder() {
        }

        public final Builder from(RequestRecurringPayment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RequestRecurringPayment instance;
            long bits = 0L;
            if (object instanceof RequestRecurringPayment) {
                instance = (RequestRecurringPayment)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.invoiceMedia(instance.invoiceMedia());
                this.userId(instance.userId());
                this.recurringInitCharge(instance.recurringInitCharge());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder recurringInitCharge(String recurringInitCharge) {
            this.recurringInitCharge = Objects.requireNonNull(recurringInitCharge, "recurringInitCharge");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder invoiceMedia(InputMedia invoiceMedia) {
            this.invoiceMedia = Objects.requireNonNull(invoiceMedia, "invoiceMedia");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRequestRecurringPayment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequestRecurringPayment(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("recurringInitCharge");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("invoiceMedia");
            }
            return "Cannot build RequestRecurringPayment, some of required attributes are not set " + attributes;
        }
    }
}

