/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputInvoice;
import telegram4j.tl.InputPaymentCredentials;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.SendPaymentForm;

public final class ImmutableSendPaymentForm
implements SendPaymentForm {
    private final int identifier;
    private final int flags;
    private final long formId;
    private final InputInvoice invoice;
    @Nullable
    private final String requestedInfoId;
    @Nullable
    private final String shippingOptionId;
    private final InputPaymentCredentials credentials;
    @Nullable
    private final Long tipAmount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendPaymentForm(long formId, InputInvoice invoice, InputPaymentCredentials credentials) {
        this.formId = formId;
        this.invoice = Objects.requireNonNull(invoice, "invoice");
        this.credentials = Objects.requireNonNull(credentials, "credentials");
        this.requestedInfoId = null;
        this.shippingOptionId = null;
        this.tipAmount = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSendPaymentForm(Builder builder) {
        this.formId = builder.formId;
        this.invoice = builder.invoice;
        this.requestedInfoId = builder.requestedInfoId;
        this.shippingOptionId = builder.shippingOptionId;
        this.credentials = builder.credentials;
        this.tipAmount = builder.tipAmount;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSendPaymentForm(int identifier, int flags, long formId, InputInvoice invoice, @Nullable String requestedInfoId, @Nullable String shippingOptionId, InputPaymentCredentials credentials, @Nullable Long tipAmount) {
        this.identifier = identifier;
        this.flags = flags;
        this.formId = formId;
        this.invoice = invoice;
        this.requestedInfoId = requestedInfoId;
        this.shippingOptionId = shippingOptionId;
        this.credentials = credentials;
        this.tipAmount = tipAmount;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendPaymentForm.super.identifier();
    }

    private int flagsInitialize() {
        return SendPaymentForm.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long formId() {
        return this.formId;
    }

    @Override
    public InputInvoice invoice() {
        return this.invoice;
    }

    @Override
    @Nullable
    public String requestedInfoId() {
        return this.requestedInfoId;
    }

    @Override
    @Nullable
    public String shippingOptionId() {
        return this.shippingOptionId;
    }

    @Override
    public InputPaymentCredentials credentials() {
        return this.credentials;
    }

    @Override
    @Nullable
    public Long tipAmount() {
        return this.tipAmount;
    }

    public final ImmutableSendPaymentForm withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendPaymentForm(value, this.flags, this.formId, this.invoice, this.requestedInfoId, this.shippingOptionId, this.credentials, this.tipAmount);
    }

    public final ImmutableSendPaymentForm withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSendPaymentForm(this.identifier, value, this.formId, this.invoice, this.requestedInfoId, this.shippingOptionId, this.credentials, this.tipAmount);
    }

    public final ImmutableSendPaymentForm withFormId(long value) {
        if (this.formId == value) {
            return this;
        }
        return new ImmutableSendPaymentForm(this.identifier, this.flags, value, this.invoice, this.requestedInfoId, this.shippingOptionId, this.credentials, this.tipAmount);
    }

    public final ImmutableSendPaymentForm withInvoice(InputInvoice value) {
        if (this.invoice == value) {
            return this;
        }
        InputInvoice newValue = Objects.requireNonNull(value, "invoice");
        return new ImmutableSendPaymentForm(this.identifier, this.flags, this.formId, newValue, this.requestedInfoId, this.shippingOptionId, this.credentials, this.tipAmount);
    }

    public final ImmutableSendPaymentForm withRequestedInfoId(@Nullable String value) {
        if (Objects.equals(this.requestedInfoId, value)) {
            return this;
        }
        return new ImmutableSendPaymentForm(this.identifier, this.flags, this.formId, this.invoice, value, this.shippingOptionId, this.credentials, this.tipAmount);
    }

    public final ImmutableSendPaymentForm withShippingOptionId(@Nullable String value) {
        if (Objects.equals(this.shippingOptionId, value)) {
            return this;
        }
        return new ImmutableSendPaymentForm(this.identifier, this.flags, this.formId, this.invoice, this.requestedInfoId, value, this.credentials, this.tipAmount);
    }

    public final ImmutableSendPaymentForm withCredentials(InputPaymentCredentials value) {
        if (this.credentials == value) {
            return this;
        }
        InputPaymentCredentials newValue = Objects.requireNonNull(value, "credentials");
        return new ImmutableSendPaymentForm(this.identifier, this.flags, this.formId, this.invoice, this.requestedInfoId, this.shippingOptionId, newValue, this.tipAmount);
    }

    public final ImmutableSendPaymentForm withTipAmount(@Nullable Long value) {
        if (Objects.equals(this.tipAmount, value)) {
            return this;
        }
        return new ImmutableSendPaymentForm(this.identifier, this.flags, this.formId, this.invoice, this.requestedInfoId, this.shippingOptionId, this.credentials, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendPaymentForm && this.equalTo(0, (ImmutableSendPaymentForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendPaymentForm another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.formId == another.formId && this.invoice.equals(another.invoice) && Objects.equals(this.requestedInfoId, another.requestedInfoId) && Objects.equals(this.shippingOptionId, another.shippingOptionId) && this.credentials.equals(another.credentials) && Objects.equals(this.tipAmount, another.tipAmount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.formId);
        h += (h << 5) + this.invoice.hashCode();
        h += (h << 5) + Objects.hashCode(this.requestedInfoId);
        h += (h << 5) + Objects.hashCode(this.shippingOptionId);
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + Objects.hashCode(this.tipAmount);
        return h;
    }

    public String toString() {
        return "SendPaymentForm{identifier=" + this.identifier + ", flags=" + this.flags + ", formId=" + this.formId + ", invoice=" + this.invoice + ", requestedInfoId=" + this.requestedInfoId + ", shippingOptionId=" + this.shippingOptionId + ", credentials=" + this.credentials + ", tipAmount=" + this.tipAmount + "}";
    }

    public static ImmutableSendPaymentForm of(long formId, InputInvoice invoice, InputPaymentCredentials credentials) {
        return new ImmutableSendPaymentForm(formId, invoice, credentials);
    }

    public static ImmutableSendPaymentForm copyOf(SendPaymentForm instance) {
        if (instance instanceof ImmutableSendPaymentForm) {
            return (ImmutableSendPaymentForm)instance;
        }
        return ImmutableSendPaymentForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FORM_ID = 1L;
        private static final long INIT_BIT_INVOICE = 2L;
        private static final long INIT_BIT_CREDENTIALS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private long formId;
        private InputInvoice invoice;
        private String requestedInfoId;
        private String shippingOptionId;
        private InputPaymentCredentials credentials;
        private Long tipAmount;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendPaymentForm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendPaymentForm) {
                String shippingOptionIdValue;
                instance = (SendPaymentForm)object;
                this.formId(instance.formId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.credentials(instance.credentials());
                Long tipAmountValue = instance.tipAmount();
                if (tipAmountValue != null) {
                    this.tipAmount(tipAmountValue);
                }
                this.flags(instance.flags());
                this.invoice(instance.invoice());
                String requestedInfoIdValue = instance.requestedInfoId();
                if (requestedInfoIdValue != null) {
                    this.requestedInfoId(requestedInfoIdValue);
                }
                if ((shippingOptionIdValue = instance.shippingOptionId()) != null) {
                    this.shippingOptionId(shippingOptionIdValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder formId(long formId) {
            this.formId = formId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder invoice(InputInvoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder requestedInfoId(@Nullable String requestedInfoId) {
            this.requestedInfoId = requestedInfoId;
            return this;
        }

        public final Builder shippingOptionId(@Nullable String shippingOptionId) {
            this.shippingOptionId = shippingOptionId;
            return this;
        }

        public final Builder credentials(InputPaymentCredentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tipAmount(@Nullable Long tipAmount) {
            this.tipAmount = tipAmount;
            return this;
        }

        public ImmutableSendPaymentForm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendPaymentForm(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("invoice");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("credentials");
            }
            return "Cannot build SendPaymentForm, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendPaymentForm.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSendPaymentForm.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build SendPaymentForm, attribute initializers form cycle " + attributes;
        }
    }
}

