/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputInvoice;
import telegram4j.tl.PaymentRequestedInfo;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.payments.ValidateRequestedInfo;

public final class ImmutableValidateRequestedInfo
implements ValidateRequestedInfo {
    private final int identifier;
    private final int flags;
    private final boolean save;
    private final InputInvoice invoice;
    private final PaymentRequestedInfo info;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableValidateRequestedInfo(InputInvoice invoice, PaymentRequestedInfo info) {
        this.invoice = Objects.requireNonNull(invoice, "invoice");
        this.info = Objects.requireNonNull(info, "info");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.save = this.initShim.save();
        this.initShim = null;
    }

    private ImmutableValidateRequestedInfo(Builder builder) {
        this.invoice = builder.invoice;
        this.info = builder.info;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.saveIsSet()) {
            this.initShim.save(builder.save);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.save = this.initShim.save();
        this.initShim = null;
    }

    private ImmutableValidateRequestedInfo(int identifier, int flags, boolean save, InputInvoice invoice, PaymentRequestedInfo info) {
        this.identifier = identifier;
        this.flags = flags;
        this.save = save;
        this.invoice = invoice;
        this.info = info;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ValidateRequestedInfo.super.identifier();
    }

    private int flagsInitialize() {
        return ValidateRequestedInfo.super.flags();
    }

    private boolean saveInitialize() {
        return ValidateRequestedInfo.super.save();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean save() {
        InitShim shim = this.initShim;
        return shim != null ? shim.save() : this.save;
    }

    @Override
    public InputInvoice invoice() {
        return this.invoice;
    }

    @Override
    public PaymentRequestedInfo info() {
        return this.info;
    }

    public final ImmutableValidateRequestedInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableValidateRequestedInfo(value, this.flags, this.save, this.invoice, this.info);
    }

    public final ImmutableValidateRequestedInfo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableValidateRequestedInfo(this.identifier, value, this.save, this.invoice, this.info);
    }

    public final ImmutableValidateRequestedInfo withSave(boolean value) {
        if (this.save == value) {
            return this;
        }
        return new ImmutableValidateRequestedInfo(this.identifier, this.flags, value, this.invoice, this.info);
    }

    public final ImmutableValidateRequestedInfo withInvoice(InputInvoice value) {
        if (this.invoice == value) {
            return this;
        }
        InputInvoice newValue = Objects.requireNonNull(value, "invoice");
        return new ImmutableValidateRequestedInfo(this.identifier, this.flags, this.save, newValue, this.info);
    }

    public final ImmutableValidateRequestedInfo withInfo(PaymentRequestedInfo value) {
        if (this.info == value) {
            return this;
        }
        PaymentRequestedInfo newValue = Objects.requireNonNull(value, "info");
        return new ImmutableValidateRequestedInfo(this.identifier, this.flags, this.save, this.invoice, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidateRequestedInfo && this.equalTo(0, (ImmutableValidateRequestedInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableValidateRequestedInfo another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.save == another.save && this.invoice.equals(another.invoice) && this.info.equals(another.info);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.save);
        h += (h << 5) + this.invoice.hashCode();
        h += (h << 5) + this.info.hashCode();
        return h;
    }

    public String toString() {
        return "ValidateRequestedInfo{identifier=" + this.identifier + ", flags=" + this.flags + ", save=" + this.save + ", invoice=" + this.invoice + ", info=" + this.info + "}";
    }

    public static ImmutableValidateRequestedInfo of(InputInvoice invoice, PaymentRequestedInfo info) {
        return new ImmutableValidateRequestedInfo(invoice, info);
    }

    public static ImmutableValidateRequestedInfo copyOf(ValidateRequestedInfo instance) {
        if (instance instanceof ImmutableValidateRequestedInfo) {
            return (ImmutableValidateRequestedInfo)instance;
        }
        return ImmutableValidateRequestedInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INVOICE = 1L;
        private static final long INIT_BIT_INFO = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SAVE = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean save;
        private InputInvoice invoice;
        private PaymentRequestedInfo info;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ValidateRequestedInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ValidateRequestedInfo) {
                instance = (ValidateRequestedInfo)object;
                this.flags(instance.flags());
                this.save(instance.save());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.invoice(instance.invoice());
                this.info(instance.info());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder save(boolean save) {
            this.save = save;
            this.optBits |= 4L;
            return this;
        }

        public final Builder invoice(InputInvoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder info(PaymentRequestedInfo info) {
            this.info = Objects.requireNonNull(info, "info");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableValidateRequestedInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidateRequestedInfo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean saveIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("invoice");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("info");
            }
            return "Cannot build ValidateRequestedInfo, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte saveBuildStage = 0;
        private boolean save;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableValidateRequestedInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableValidateRequestedInfo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean save() {
            if (this.saveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.saveBuildStage == 0) {
                this.saveBuildStage = (byte)-1;
                this.save = ImmutableValidateRequestedInfo.this.saveInitialize();
                this.saveBuildStage = 1;
            }
            return this.save;
        }

        void save(boolean save) {
            this.save = save;
            this.saveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.saveBuildStage == -1) {
                attributes.add("save");
            }
            return "Cannot build ValidateRequestedInfo, attribute initializers form cycle " + attributes;
        }
    }
}

