/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.PhoneCallProtocol;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.AcceptCall;

public final class ImmutableAcceptCall
implements AcceptCall {
    private final int identifier;
    private final InputPhoneCall peer;
    private final ByteBuf gB;
    private final PhoneCallProtocol protocol;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAcceptCall(InputPhoneCall peer, PhoneCallProtocol protocol) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.gB = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableAcceptCall(Builder builder) {
        this.peer = builder.peer;
        this.gB = builder.gB_build();
        this.protocol = builder.protocol;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableAcceptCall(int identifier, InputPhoneCall peer, ByteBuf gB, PhoneCallProtocol protocol) {
        this.identifier = identifier;
        this.peer = peer;
        this.gB = gB;
        this.protocol = protocol;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AcceptCall.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    @Override
    public ByteBuf gB() {
        return this.gB.duplicate();
    }

    @Override
    public PhoneCallProtocol protocol() {
        return this.protocol;
    }

    public final ImmutableAcceptCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAcceptCall(value, this.peer, this.gB, this.protocol);
    }

    public final ImmutableAcceptCall withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableAcceptCall(this.identifier, newValue, this.gB, this.protocol);
    }

    public ImmutableAcceptCall withGB(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gB == newValue) {
            return this;
        }
        return new ImmutableAcceptCall(this.identifier, this.peer, newValue, this.protocol);
    }

    public final ImmutableAcceptCall withProtocol(PhoneCallProtocol value) {
        if (this.protocol == value) {
            return this;
        }
        PhoneCallProtocol newValue = Objects.requireNonNull(value, "protocol");
        return new ImmutableAcceptCall(this.identifier, this.peer, this.gB, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptCall && this.equalTo(0, (ImmutableAcceptCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableAcceptCall another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.gB().equals((Object)another.gB()) && this.protocol.equals(another.protocol);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.gB().hashCode();
        h += (h << 5) + this.protocol.hashCode();
        return h;
    }

    public String toString() {
        return "AcceptCall{identifier=" + this.identifier + ", peer=" + this.peer + ", gB=" + ByteBufUtil.hexDump((ByteBuf)this.gB) + ", protocol=" + this.protocol + "}";
    }

    public static ImmutableAcceptCall of(InputPhoneCall peer, PhoneCallProtocol protocol) {
        return new ImmutableAcceptCall(peer, protocol);
    }

    public static ImmutableAcceptCall copyOf(AcceptCall instance) {
        if (instance instanceof ImmutableAcceptCall) {
            return (ImmutableAcceptCall)instance;
        }
        return ImmutableAcceptCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_PROTOCOL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf gB_value = null;
        private int identifier;
        private InputPhoneCall peer;
        private PhoneCallProtocol protocol;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AcceptCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AcceptCall) {
                instance = (AcceptCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.protocol(instance.protocol());
                this.gB(instance.gB());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder gB(ByteBuf value) {
            this.gB_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder protocol(PhoneCallProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAcceptCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAcceptCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("protocol");
            }
            return "Cannot build AcceptCall, some of required attributes are not set " + attributes;
        }

        private ByteBuf gB_build() {
            return Objects.requireNonNull(this.gB_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAcceptCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build AcceptCall, attribute initializers form cycle " + attributes;
        }
    }
}

