/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.CheckGroupCall;

public final class ImmutableCheckGroupCall
implements CheckGroupCall {
    private final int identifier;
    private final InputGroupCall call;
    private final List<Integer> sources;

    private ImmutableCheckGroupCall(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.sources = Collections.emptyList();
        this.identifier = CheckGroupCall.super.identifier();
    }

    private ImmutableCheckGroupCall(Builder builder) {
        this.call = builder.call;
        this.sources = ImmutableCheckGroupCall.createUnmodifiableList(true, builder.sources);
        this.identifier = builder.identifierIsSet() ? builder.identifier : CheckGroupCall.super.identifier();
    }

    private ImmutableCheckGroupCall(int identifier, InputGroupCall call, List<Integer> sources) {
        this.identifier = identifier;
        this.call = call;
        this.sources = sources;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public List<Integer> sources() {
        return this.sources;
    }

    public final ImmutableCheckGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCheckGroupCall(value, this.call, this.sources);
    }

    public final ImmutableCheckGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableCheckGroupCall(this.identifier, newValue, this.sources);
    }

    public final ImmutableCheckGroupCall withSources(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableCheckGroupCall.createUnmodifiableList(false, wrappedList);
        return new ImmutableCheckGroupCall(this.identifier, this.call, newValue);
    }

    public final ImmutableCheckGroupCall withSources(Iterable<Integer> elements) {
        if (this.sources == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableCheckGroupCall.createUnmodifiableList(false, ImmutableCheckGroupCall.createSafeList(elements, true, false));
        return new ImmutableCheckGroupCall(this.identifier, this.call, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckGroupCall && this.equalTo(0, (ImmutableCheckGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckGroupCall another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.sources.equals(another.sources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.sources.hashCode();
        return h;
    }

    public String toString() {
        return "CheckGroupCall{identifier=" + this.identifier + ", call=" + this.call + ", sources=" + this.sources + "}";
    }

    public static ImmutableCheckGroupCall of(InputGroupCall call) {
        return new ImmutableCheckGroupCall(call);
    }

    public static ImmutableCheckGroupCall copyOf(CheckGroupCall instance) {
        if (instance instanceof ImmutableCheckGroupCall) {
            return (ImmutableCheckGroupCall)instance;
        }
        return ImmutableCheckGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private List<Integer> sources = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(CheckGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CheckGroupCall instance;
            long bits = 0L;
            if (object instanceof CheckGroupCall) {
                instance = (CheckGroupCall)object;
                this.call(instance.call());
                this.addAllSources(instance.sources());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSource(int element) {
            this.sources.add(element);
            return this;
        }

        public final Builder addSources(int ... elements) {
            for (int element : elements) {
                this.sources.add(element);
            }
            return this;
        }

        public final Builder sources(Iterable<Integer> elements) {
            this.sources.clear();
            return this.addAllSources(elements);
        }

        public final Builder addAllSources(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.sources.add(Objects.requireNonNull(element, "sources element"));
            }
            return this;
        }

        public ImmutableCheckGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build CheckGroupCall, some of required attributes are not set " + attributes;
        }
    }
}

