/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.PhoneCallProtocol;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.ConfirmCall;

public final class ImmutableConfirmCall
implements ConfirmCall {
    private final int identifier;
    private final InputPhoneCall peer;
    private final ByteBuf gA;
    private final long keyFingerprint;
    private final PhoneCallProtocol protocol;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableConfirmCall(InputPhoneCall peer, long keyFingerprint, PhoneCallProtocol protocol) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.keyFingerprint = keyFingerprint;
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.gA = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableConfirmCall(Builder builder) {
        this.peer = builder.peer;
        this.gA = builder.gA_build();
        this.keyFingerprint = builder.keyFingerprint;
        this.protocol = builder.protocol;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableConfirmCall(int identifier, InputPhoneCall peer, ByteBuf gA, long keyFingerprint, PhoneCallProtocol protocol) {
        this.identifier = identifier;
        this.peer = peer;
        this.gA = gA;
        this.keyFingerprint = keyFingerprint;
        this.protocol = protocol;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ConfirmCall.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    @Override
    public ByteBuf gA() {
        return this.gA.duplicate();
    }

    @Override
    public long keyFingerprint() {
        return this.keyFingerprint;
    }

    @Override
    public PhoneCallProtocol protocol() {
        return this.protocol;
    }

    public final ImmutableConfirmCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableConfirmCall(value, this.peer, this.gA, this.keyFingerprint, this.protocol);
    }

    public final ImmutableConfirmCall withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableConfirmCall(this.identifier, newValue, this.gA, this.keyFingerprint, this.protocol);
    }

    public ImmutableConfirmCall withGA(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gA == newValue) {
            return this;
        }
        return new ImmutableConfirmCall(this.identifier, this.peer, newValue, this.keyFingerprint, this.protocol);
    }

    public final ImmutableConfirmCall withKeyFingerprint(long value) {
        if (this.keyFingerprint == value) {
            return this;
        }
        return new ImmutableConfirmCall(this.identifier, this.peer, this.gA, value, this.protocol);
    }

    public final ImmutableConfirmCall withProtocol(PhoneCallProtocol value) {
        if (this.protocol == value) {
            return this;
        }
        PhoneCallProtocol newValue = Objects.requireNonNull(value, "protocol");
        return new ImmutableConfirmCall(this.identifier, this.peer, this.gA, this.keyFingerprint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfirmCall && this.equalTo(0, (ImmutableConfirmCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfirmCall another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.gA().equals((Object)another.gA()) && this.keyFingerprint == another.keyFingerprint && this.protocol.equals(another.protocol);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.gA().hashCode();
        h += (h << 5) + Long.hashCode(this.keyFingerprint);
        h += (h << 5) + this.protocol.hashCode();
        return h;
    }

    public String toString() {
        return "ConfirmCall{identifier=" + this.identifier + ", peer=" + this.peer + ", gA=" + ByteBufUtil.hexDump((ByteBuf)this.gA) + ", keyFingerprint=" + this.keyFingerprint + ", protocol=" + this.protocol + "}";
    }

    public static ImmutableConfirmCall of(InputPhoneCall peer, long keyFingerprint, PhoneCallProtocol protocol) {
        return new ImmutableConfirmCall(peer, keyFingerprint, protocol);
    }

    public static ImmutableConfirmCall copyOf(ConfirmCall instance) {
        if (instance instanceof ImmutableConfirmCall) {
            return (ImmutableConfirmCall)instance;
        }
        return ImmutableConfirmCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_KEY_FINGERPRINT = 2L;
        private static final long INIT_BIT_PROTOCOL = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf gA_value = null;
        private int identifier;
        private InputPhoneCall peer;
        private long keyFingerprint;
        private PhoneCallProtocol protocol;

        private Builder() {
        }

        public final Builder from(ConfirmCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConfirmCall instance;
            long bits = 0L;
            if (object instanceof ConfirmCall) {
                instance = (ConfirmCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.protocol(instance.protocol());
                this.gA(instance.gA());
                this.peer(instance.peer());
                this.keyFingerprint(instance.keyFingerprint());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder gA(ByteBuf value) {
            this.gA_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder keyFingerprint(long keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder protocol(PhoneCallProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableConfirmCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfirmCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyFingerprint");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("protocol");
            }
            return "Cannot build ConfirmCall, some of required attributes are not set " + attributes;
        }

        private ByteBuf gA_build() {
            return Objects.requireNonNull(this.gA_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableConfirmCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ConfirmCall, attribute initializers form cycle " + attributes;
        }
    }
}

