/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.CreateGroupCall;

public final class ImmutableCreateGroupCall
implements CreateGroupCall {
    private final int identifier;
    private final int flags;
    private final boolean rtmpStream;
    private final InputPeer peer;
    private final int randomId;
    @Nullable
    private final String title;
    @Nullable
    private final Integer scheduleDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCreateGroupCall(InputPeer peer, int randomId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.randomId = randomId;
        this.title = null;
        this.scheduleDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.rtmpStream = this.initShim.rtmpStream();
        this.initShim = null;
    }

    private ImmutableCreateGroupCall(Builder builder) {
        this.peer = builder.peer;
        this.randomId = builder.randomId;
        this.title = builder.title;
        this.scheduleDate = builder.scheduleDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.rtmpStreamIsSet()) {
            this.initShim.rtmpStream(builder.rtmpStream);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.rtmpStream = this.initShim.rtmpStream();
        this.initShim = null;
    }

    private ImmutableCreateGroupCall(int identifier, int flags, boolean rtmpStream, InputPeer peer, int randomId, @Nullable String title, @Nullable Integer scheduleDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.rtmpStream = rtmpStream;
        this.peer = peer;
        this.randomId = randomId;
        this.title = title;
        this.scheduleDate = scheduleDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return CreateGroupCall.super.identifier();
    }

    private int flagsInitialize() {
        return CreateGroupCall.super.flags();
    }

    private boolean rtmpStreamInitialize() {
        return CreateGroupCall.super.rtmpStream();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean rtmpStream() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rtmpStream() : this.rtmpStream;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int randomId() {
        return this.randomId;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public Integer scheduleDate() {
        return this.scheduleDate;
    }

    public final ImmutableCreateGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCreateGroupCall(value, this.flags, this.rtmpStream, this.peer, this.randomId, this.title, this.scheduleDate);
    }

    public final ImmutableCreateGroupCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableCreateGroupCall(this.identifier, value, this.rtmpStream, this.peer, this.randomId, this.title, this.scheduleDate);
    }

    public final ImmutableCreateGroupCall withRtmpStream(boolean value) {
        if (this.rtmpStream == value) {
            return this;
        }
        return new ImmutableCreateGroupCall(this.identifier, this.flags, value, this.peer, this.randomId, this.title, this.scheduleDate);
    }

    public final ImmutableCreateGroupCall withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableCreateGroupCall(this.identifier, this.flags, this.rtmpStream, newValue, this.randomId, this.title, this.scheduleDate);
    }

    public final ImmutableCreateGroupCall withRandomId(int value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableCreateGroupCall(this.identifier, this.flags, this.rtmpStream, this.peer, value, this.title, this.scheduleDate);
    }

    public final ImmutableCreateGroupCall withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableCreateGroupCall(this.identifier, this.flags, this.rtmpStream, this.peer, this.randomId, value, this.scheduleDate);
    }

    public final ImmutableCreateGroupCall withScheduleDate(@Nullable Integer value) {
        if (Objects.equals(this.scheduleDate, value)) {
            return this;
        }
        return new ImmutableCreateGroupCall(this.identifier, this.flags, this.rtmpStream, this.peer, this.randomId, this.title, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateGroupCall && this.equalTo(0, (ImmutableCreateGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateGroupCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.rtmpStream == another.rtmpStream && this.peer.equals(another.peer) && this.randomId == another.randomId && Objects.equals(this.title, another.title) && Objects.equals(this.scheduleDate, another.scheduleDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.rtmpStream);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.randomId;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.scheduleDate);
        return h;
    }

    public String toString() {
        return "CreateGroupCall{identifier=" + this.identifier + ", flags=" + this.flags + ", rtmpStream=" + this.rtmpStream + ", peer=" + this.peer + ", randomId=" + this.randomId + ", title=" + this.title + ", scheduleDate=" + this.scheduleDate + "}";
    }

    public static ImmutableCreateGroupCall of(InputPeer peer, int randomId) {
        return new ImmutableCreateGroupCall(peer, randomId);
    }

    public static ImmutableCreateGroupCall copyOf(CreateGroupCall instance) {
        if (instance instanceof ImmutableCreateGroupCall) {
            return (ImmutableCreateGroupCall)instance;
        }
        return ImmutableCreateGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_RTMP_STREAM = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean rtmpStream;
        private InputPeer peer;
        private int randomId;
        private String title;
        private Integer scheduleDate;

        private Builder() {
        }

        public final Builder from(CreateGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CreateGroupCall instance;
            long bits = 0L;
            if (object instanceof CreateGroupCall) {
                String titleValue;
                instance = (CreateGroupCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                this.peer(instance.peer());
                this.flags(instance.flags());
                Integer scheduleDateValue = instance.scheduleDate();
                if (scheduleDateValue != null) {
                    this.scheduleDate(scheduleDateValue);
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
                this.rtmpStream(instance.rtmpStream());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder rtmpStream(boolean rtmpStream) {
            this.rtmpStream = rtmpStream;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(int randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder scheduleDate(@Nullable Integer scheduleDate) {
            this.scheduleDate = scheduleDate;
            return this;
        }

        public ImmutableCreateGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean rtmpStreamIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            return "Cannot build CreateGroupCall, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte rtmpStreamBuildStage = 0;
        private boolean rtmpStream;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCreateGroupCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableCreateGroupCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean rtmpStream() {
            if (this.rtmpStreamBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rtmpStreamBuildStage == 0) {
                this.rtmpStreamBuildStage = (byte)-1;
                this.rtmpStream = ImmutableCreateGroupCall.this.rtmpStreamInitialize();
                this.rtmpStreamBuildStage = 1;
            }
            return this.rtmpStream;
        }

        void rtmpStream(boolean rtmpStream) {
            this.rtmpStream = rtmpStream;
            this.rtmpStreamBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.rtmpStreamBuildStage == -1) {
                attributes.add("rtmpStream");
            }
            return "Cannot build CreateGroupCall, attribute initializers form cycle " + attributes;
        }
    }
}

