/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.PhoneCallDiscardReason;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.DiscardCall;

public final class ImmutableDiscardCall
implements DiscardCall {
    private final int identifier;
    private final int flags;
    private final boolean video;
    private final InputPhoneCall peer;
    private final int duration;
    private final PhoneCallDiscardReason reason;
    private final long connectionId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDiscardCall(InputPhoneCall peer, int duration, PhoneCallDiscardReason reason, long connectionId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.duration = duration;
        this.reason = Objects.requireNonNull(reason, "reason");
        this.connectionId = connectionId;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableDiscardCall(Builder builder) {
        this.peer = builder.peer;
        this.duration = builder.duration;
        this.reason = builder.reason;
        this.connectionId = builder.connectionId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableDiscardCall(int identifier, int flags, boolean video, InputPhoneCall peer, int duration, PhoneCallDiscardReason reason, long connectionId) {
        this.identifier = identifier;
        this.flags = flags;
        this.video = video;
        this.peer = peer;
        this.duration = duration;
        this.reason = reason;
        this.connectionId = connectionId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DiscardCall.super.identifier();
    }

    private int flagsInitialize() {
        return DiscardCall.super.flags();
    }

    private boolean videoInitialize() {
        return DiscardCall.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    @Override
    public int duration() {
        return this.duration;
    }

    @Override
    public PhoneCallDiscardReason reason() {
        return this.reason;
    }

    @Override
    public long connectionId() {
        return this.connectionId;
    }

    public final ImmutableDiscardCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDiscardCall(value, this.flags, this.video, this.peer, this.duration, this.reason, this.connectionId);
    }

    public final ImmutableDiscardCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDiscardCall(this.identifier, value, this.video, this.peer, this.duration, this.reason, this.connectionId);
    }

    public final ImmutableDiscardCall withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutableDiscardCall(this.identifier, this.flags, value, this.peer, this.duration, this.reason, this.connectionId);
    }

    public final ImmutableDiscardCall withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableDiscardCall(this.identifier, this.flags, this.video, newValue, this.duration, this.reason, this.connectionId);
    }

    public final ImmutableDiscardCall withDuration(int value) {
        if (this.duration == value) {
            return this;
        }
        return new ImmutableDiscardCall(this.identifier, this.flags, this.video, this.peer, value, this.reason, this.connectionId);
    }

    public final ImmutableDiscardCall withReason(PhoneCallDiscardReason value) {
        PhoneCallDiscardReason newValue = Objects.requireNonNull(value, "reason");
        if (this.reason == newValue) {
            return this;
        }
        return new ImmutableDiscardCall(this.identifier, this.flags, this.video, this.peer, this.duration, newValue, this.connectionId);
    }

    public final ImmutableDiscardCall withConnectionId(long value) {
        if (this.connectionId == value) {
            return this;
        }
        return new ImmutableDiscardCall(this.identifier, this.flags, this.video, this.peer, this.duration, this.reason, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiscardCall && this.equalTo(0, (ImmutableDiscardCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiscardCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.video == another.video && this.peer.equals(another.peer) && this.duration == another.duration && this.reason.equals((Object)another.reason) && this.connectionId == another.connectionId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.duration;
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + Long.hashCode(this.connectionId);
        return h;
    }

    public String toString() {
        return "DiscardCall{identifier=" + this.identifier + ", flags=" + this.flags + ", video=" + this.video + ", peer=" + this.peer + ", duration=" + this.duration + ", reason=" + this.reason + ", connectionId=" + this.connectionId + "}";
    }

    public static ImmutableDiscardCall of(InputPhoneCall peer, int duration, PhoneCallDiscardReason reason, long connectionId) {
        return new ImmutableDiscardCall(peer, duration, reason, connectionId);
    }

    public static ImmutableDiscardCall copyOf(DiscardCall instance) {
        if (instance instanceof ImmutableDiscardCall) {
            return (ImmutableDiscardCall)instance;
        }
        return ImmutableDiscardCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_DURATION = 2L;
        private static final long INIT_BIT_REASON = 4L;
        private static final long INIT_BIT_CONNECTION_ID = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_VIDEO = 4L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean video;
        private InputPhoneCall peer;
        private int duration;
        private PhoneCallDiscardReason reason;
        private long connectionId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DiscardCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DiscardCall) {
                instance = (DiscardCall)object;
                this.duration(instance.duration());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reason(instance.reason());
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.connectionId(instance.connectionId());
                this.video(instance.video());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder duration(int duration) {
            this.duration = duration;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder reason(PhoneCallDiscardReason reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder connectionId(long connectionId) {
            this.connectionId = connectionId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableDiscardCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiscardCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("duration");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("reason");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("connectionId");
            }
            return "Cannot build DiscardCall, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDiscardCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDiscardCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutableDiscardCall.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build DiscardCall, attribute initializers form cycle " + attributes;
        }
    }
}

