/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.DiscardGroupCall;

public final class ImmutableDiscardGroupCall
implements DiscardGroupCall {
    private final int identifier;
    private final InputGroupCall call;

    private ImmutableDiscardGroupCall(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.identifier = DiscardGroupCall.super.identifier();
    }

    private ImmutableDiscardGroupCall(Builder builder) {
        this.call = builder.call;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DiscardGroupCall.super.identifier();
    }

    private ImmutableDiscardGroupCall(int identifier, InputGroupCall call) {
        this.identifier = identifier;
        this.call = call;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    public final ImmutableDiscardGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDiscardGroupCall(value, this.call);
    }

    public final ImmutableDiscardGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableDiscardGroupCall(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiscardGroupCall && this.equalTo(0, (ImmutableDiscardGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiscardGroupCall another) {
        return this.identifier == another.identifier && this.call.equals(another.call);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        return h;
    }

    public String toString() {
        return "DiscardGroupCall{identifier=" + this.identifier + ", call=" + this.call + "}";
    }

    public static ImmutableDiscardGroupCall of(InputGroupCall call) {
        return new ImmutableDiscardGroupCall(call);
    }

    public static ImmutableDiscardGroupCall copyOf(DiscardGroupCall instance) {
        if (instance instanceof ImmutableDiscardGroupCall) {
            return (ImmutableDiscardGroupCall)instance;
        }
        return ImmutableDiscardGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;

        private Builder() {
        }

        public final Builder from(DiscardGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DiscardGroupCall instance;
            long bits = 0L;
            if (object instanceof DiscardGroupCall) {
                instance = (DiscardGroupCall)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDiscardGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiscardGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build DiscardGroupCall, some of required attributes are not set " + attributes;
        }
    }
}

