/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.EditGroupCallParticipant;

public final class ImmutableEditGroupCallParticipant
implements EditGroupCallParticipant {
    private final int identifier;
    private final int flags;
    private final InputGroupCall call;
    private final InputPeer participant;
    @Nullable
    private final Boolean muted;
    @Nullable
    private final Integer volume;
    @Nullable
    private final Boolean raiseHand;
    @Nullable
    private final Boolean videoStopped;
    @Nullable
    private final Boolean videoPaused;
    @Nullable
    private final Boolean presentationPaused;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEditGroupCallParticipant(InputGroupCall call, InputPeer participant) {
        this.call = Objects.requireNonNull(call, "call");
        this.participant = Objects.requireNonNull(participant, "participant");
        this.muted = null;
        this.volume = null;
        this.raiseHand = null;
        this.videoStopped = null;
        this.videoPaused = null;
        this.presentationPaused = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableEditGroupCallParticipant(Builder builder) {
        this.call = builder.call;
        this.participant = builder.participant;
        this.muted = builder.muted;
        this.volume = builder.volume;
        this.raiseHand = builder.raiseHand;
        this.videoStopped = builder.videoStopped;
        this.videoPaused = builder.videoPaused;
        this.presentationPaused = builder.presentationPaused;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableEditGroupCallParticipant(int identifier, int flags, InputGroupCall call, InputPeer participant, @Nullable Boolean muted, @Nullable Integer volume, @Nullable Boolean raiseHand, @Nullable Boolean videoStopped, @Nullable Boolean videoPaused, @Nullable Boolean presentationPaused) {
        this.identifier = identifier;
        this.flags = flags;
        this.call = call;
        this.participant = participant;
        this.muted = muted;
        this.volume = volume;
        this.raiseHand = raiseHand;
        this.videoStopped = videoStopped;
        this.videoPaused = videoPaused;
        this.presentationPaused = presentationPaused;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return EditGroupCallParticipant.super.identifier();
    }

    private int flagsInitialize() {
        return EditGroupCallParticipant.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public InputPeer participant() {
        return this.participant;
    }

    @Override
    @Nullable
    public Boolean muted() {
        return this.muted;
    }

    @Override
    @Nullable
    public Integer volume() {
        return this.volume;
    }

    @Override
    @Nullable
    public Boolean raiseHand() {
        return this.raiseHand;
    }

    @Override
    @Nullable
    public Boolean videoStopped() {
        return this.videoStopped;
    }

    @Override
    @Nullable
    public Boolean videoPaused() {
        return this.videoPaused;
    }

    @Override
    @Nullable
    public Boolean presentationPaused() {
        return this.presentationPaused;
    }

    public final ImmutableEditGroupCallParticipant withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(value, this.flags, this.call, this.participant, this.muted, this.volume, this.raiseHand, this.videoStopped, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(this.identifier, value, this.call, this.participant, this.muted, this.volume, this.raiseHand, this.videoStopped, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, newValue, this.participant, this.muted, this.volume, this.raiseHand, this.videoStopped, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withParticipant(InputPeer value) {
        if (this.participant == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "participant");
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, this.call, newValue, this.muted, this.volume, this.raiseHand, this.videoStopped, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withMuted(@Nullable Boolean value) {
        if (Objects.equals(this.muted, value)) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, this.call, this.participant, value, this.volume, this.raiseHand, this.videoStopped, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withVolume(@Nullable Integer value) {
        if (Objects.equals(this.volume, value)) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, this.call, this.participant, this.muted, value, this.raiseHand, this.videoStopped, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withRaiseHand(@Nullable Boolean value) {
        if (Objects.equals(this.raiseHand, value)) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, this.call, this.participant, this.muted, this.volume, value, this.videoStopped, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withVideoStopped(@Nullable Boolean value) {
        if (Objects.equals(this.videoStopped, value)) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, this.call, this.participant, this.muted, this.volume, this.raiseHand, value, this.videoPaused, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withVideoPaused(@Nullable Boolean value) {
        if (Objects.equals(this.videoPaused, value)) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, this.call, this.participant, this.muted, this.volume, this.raiseHand, this.videoStopped, value, this.presentationPaused);
    }

    public final ImmutableEditGroupCallParticipant withPresentationPaused(@Nullable Boolean value) {
        if (Objects.equals(this.presentationPaused, value)) {
            return this;
        }
        return new ImmutableEditGroupCallParticipant(this.identifier, this.flags, this.call, this.participant, this.muted, this.volume, this.raiseHand, this.videoStopped, this.videoPaused, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditGroupCallParticipant && this.equalTo(0, (ImmutableEditGroupCallParticipant)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditGroupCallParticipant another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.call.equals(another.call) && this.participant.equals(another.participant) && Objects.equals(this.muted, another.muted) && Objects.equals(this.volume, another.volume) && Objects.equals(this.raiseHand, another.raiseHand) && Objects.equals(this.videoStopped, another.videoStopped) && Objects.equals(this.videoPaused, another.videoPaused) && Objects.equals(this.presentationPaused, another.presentationPaused);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.participant.hashCode();
        h += (h << 5) + Objects.hashCode(this.muted);
        h += (h << 5) + Objects.hashCode(this.volume);
        h += (h << 5) + Objects.hashCode(this.raiseHand);
        h += (h << 5) + Objects.hashCode(this.videoStopped);
        h += (h << 5) + Objects.hashCode(this.videoPaused);
        h += (h << 5) + Objects.hashCode(this.presentationPaused);
        return h;
    }

    public String toString() {
        return "EditGroupCallParticipant{identifier=" + this.identifier + ", flags=" + this.flags + ", call=" + this.call + ", participant=" + this.participant + ", muted=" + this.muted + ", volume=" + this.volume + ", raiseHand=" + this.raiseHand + ", videoStopped=" + this.videoStopped + ", videoPaused=" + this.videoPaused + ", presentationPaused=" + this.presentationPaused + "}";
    }

    public static ImmutableEditGroupCallParticipant of(InputGroupCall call, InputPeer participant) {
        return new ImmutableEditGroupCallParticipant(call, participant);
    }

    public static ImmutableEditGroupCallParticipant copyOf(EditGroupCallParticipant instance) {
        if (instance instanceof ImmutableEditGroupCallParticipant) {
            return (ImmutableEditGroupCallParticipant)instance;
        }
        return ImmutableEditGroupCallParticipant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_PARTICIPANT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputGroupCall call;
        private InputPeer participant;
        private Boolean muted;
        private Integer volume;
        private Boolean raiseHand;
        private Boolean videoStopped;
        private Boolean videoPaused;
        private Boolean presentationPaused;

        private Builder() {
        }

        public final Builder from(EditGroupCallParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EditGroupCallParticipant instance;
            long bits = 0L;
            if (object instanceof EditGroupCallParticipant) {
                Boolean mutedValue;
                Boolean presentationPausedValue;
                Boolean videoPausedValue;
                Boolean raiseHandValue;
                instance = (EditGroupCallParticipant)object;
                this.call(instance.call());
                Integer volumeValue = instance.volume();
                if (volumeValue != null) {
                    this.volume(volumeValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((raiseHandValue = instance.raiseHand()) != null) {
                    this.raiseHand(raiseHandValue);
                }
                this.flags(instance.flags());
                Boolean videoStoppedValue = instance.videoStopped();
                if (videoStoppedValue != null) {
                    this.videoStopped(videoStoppedValue);
                }
                if ((videoPausedValue = instance.videoPaused()) != null) {
                    this.videoPaused(videoPausedValue);
                }
                if ((presentationPausedValue = instance.presentationPaused()) != null) {
                    this.presentationPaused(presentationPausedValue);
                }
                if ((mutedValue = instance.muted()) != null) {
                    this.muted(mutedValue);
                }
                this.participant(instance.participant());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder participant(InputPeer participant) {
            this.participant = Objects.requireNonNull(participant, "participant");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder muted(@Nullable Boolean muted) {
            this.muted = muted;
            return this;
        }

        public final Builder volume(@Nullable Integer volume) {
            this.volume = volume;
            return this;
        }

        public final Builder raiseHand(@Nullable Boolean raiseHand) {
            this.raiseHand = raiseHand;
            return this;
        }

        public final Builder videoStopped(@Nullable Boolean videoStopped) {
            this.videoStopped = videoStopped;
            return this;
        }

        public final Builder videoPaused(@Nullable Boolean videoPaused) {
            this.videoPaused = videoPaused;
            return this;
        }

        public final Builder presentationPaused(@Nullable Boolean presentationPaused) {
            this.presentationPaused = presentationPaused;
            return this;
        }

        public ImmutableEditGroupCallParticipant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditGroupCallParticipant(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("participant");
            }
            return "Cannot build EditGroupCallParticipant, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableEditGroupCallParticipant.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableEditGroupCallParticipant.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build EditGroupCallParticipant, attribute initializers form cycle " + attributes;
        }
    }
}

