/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.EditGroupCallTitle;

public final class ImmutableEditGroupCallTitle
implements EditGroupCallTitle {
    private final int identifier;
    private final InputGroupCall call;
    private final String title;

    private ImmutableEditGroupCallTitle(InputGroupCall call, String title) {
        this.call = Objects.requireNonNull(call, "call");
        this.title = Objects.requireNonNull(title, "title");
        this.identifier = EditGroupCallTitle.super.identifier();
    }

    private ImmutableEditGroupCallTitle(Builder builder) {
        this.call = builder.call;
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EditGroupCallTitle.super.identifier();
    }

    private ImmutableEditGroupCallTitle(int identifier, InputGroupCall call, String title) {
        this.identifier = identifier;
        this.call = call;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableEditGroupCallTitle withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEditGroupCallTitle(value, this.call, this.title);
    }

    public final ImmutableEditGroupCallTitle withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableEditGroupCallTitle(this.identifier, newValue, this.title);
    }

    public final ImmutableEditGroupCallTitle withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableEditGroupCallTitle(this.identifier, this.call, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEditGroupCallTitle && this.equalTo(0, (ImmutableEditGroupCallTitle)another);
    }

    private boolean equalTo(int synthetic, ImmutableEditGroupCallTitle another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "EditGroupCallTitle{identifier=" + this.identifier + ", call=" + this.call + ", title=" + this.title + "}";
    }

    public static ImmutableEditGroupCallTitle of(InputGroupCall call, String title) {
        return new ImmutableEditGroupCallTitle(call, title);
    }

    public static ImmutableEditGroupCallTitle copyOf(EditGroupCallTitle instance) {
        if (instance instanceof ImmutableEditGroupCallTitle) {
            return (ImmutableEditGroupCallTitle)instance;
        }
        return ImmutableEditGroupCallTitle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private String title;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EditGroupCallTitle instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EditGroupCallTitle) {
                instance = (EditGroupCallTitle)object;
                this.call(instance.call());
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEditGroupCallTitle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEditGroupCallTitle(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build EditGroupCallTitle, some of required attributes are not set " + attributes;
        }
    }
}

