/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.ExportGroupCallInvite;

public final class ImmutableExportGroupCallInvite
implements ExportGroupCallInvite {
    private final int identifier;
    private final int flags;
    private final boolean canSelfUnmute;
    private final InputGroupCall call;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExportGroupCallInvite(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canSelfUnmute = this.initShim.canSelfUnmute();
        this.initShim = null;
    }

    private ImmutableExportGroupCallInvite(Builder builder) {
        this.call = builder.call;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.canSelfUnmuteIsSet()) {
            this.initShim.canSelfUnmute(builder.canSelfUnmute);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canSelfUnmute = this.initShim.canSelfUnmute();
        this.initShim = null;
    }

    private ImmutableExportGroupCallInvite(int identifier, int flags, boolean canSelfUnmute, InputGroupCall call) {
        this.identifier = identifier;
        this.flags = flags;
        this.canSelfUnmute = canSelfUnmute;
        this.call = call;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ExportGroupCallInvite.super.identifier();
    }

    private int flagsInitialize() {
        return ExportGroupCallInvite.super.flags();
    }

    private boolean canSelfUnmuteInitialize() {
        return ExportGroupCallInvite.super.canSelfUnmute();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean canSelfUnmute() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSelfUnmute() : this.canSelfUnmute;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    public final ImmutableExportGroupCallInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportGroupCallInvite(value, this.flags, this.canSelfUnmute, this.call);
    }

    public final ImmutableExportGroupCallInvite withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableExportGroupCallInvite(this.identifier, value, this.canSelfUnmute, this.call);
    }

    public final ImmutableExportGroupCallInvite withCanSelfUnmute(boolean value) {
        if (this.canSelfUnmute == value) {
            return this;
        }
        return new ImmutableExportGroupCallInvite(this.identifier, this.flags, value, this.call);
    }

    public final ImmutableExportGroupCallInvite withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableExportGroupCallInvite(this.identifier, this.flags, this.canSelfUnmute, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportGroupCallInvite && this.equalTo(0, (ImmutableExportGroupCallInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportGroupCallInvite another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.canSelfUnmute == another.canSelfUnmute && this.call.equals(another.call);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.canSelfUnmute);
        h += (h << 5) + this.call.hashCode();
        return h;
    }

    public String toString() {
        return "ExportGroupCallInvite{identifier=" + this.identifier + ", flags=" + this.flags + ", canSelfUnmute=" + this.canSelfUnmute + ", call=" + this.call + "}";
    }

    public static ImmutableExportGroupCallInvite of(InputGroupCall call) {
        return new ImmutableExportGroupCallInvite(call);
    }

    public static ImmutableExportGroupCallInvite copyOf(ExportGroupCallInvite instance) {
        if (instance instanceof ImmutableExportGroupCallInvite) {
            return (ImmutableExportGroupCallInvite)instance;
        }
        return ImmutableExportGroupCallInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CAN_SELF_UNMUTE = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean canSelfUnmute;
        private InputGroupCall call;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExportGroupCallInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ExportGroupCallInvite) {
                instance = (ExportGroupCallInvite)object;
                this.call(instance.call());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.canSelfUnmute(instance.canSelfUnmute());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder canSelfUnmute(boolean canSelfUnmute) {
            this.canSelfUnmute = canSelfUnmute;
            this.optBits |= 4L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExportGroupCallInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportGroupCallInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean canSelfUnmuteIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build ExportGroupCallInvite, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte canSelfUnmuteBuildStage = 0;
        private boolean canSelfUnmute;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableExportGroupCallInvite.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableExportGroupCallInvite.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean canSelfUnmute() {
            if (this.canSelfUnmuteBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSelfUnmuteBuildStage == 0) {
                this.canSelfUnmuteBuildStage = (byte)-1;
                this.canSelfUnmute = ImmutableExportGroupCallInvite.this.canSelfUnmuteInitialize();
                this.canSelfUnmuteBuildStage = 1;
            }
            return this.canSelfUnmute;
        }

        void canSelfUnmute(boolean canSelfUnmute) {
            this.canSelfUnmute = canSelfUnmute;
            this.canSelfUnmuteBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.canSelfUnmuteBuildStage == -1) {
                attributes.add("canSelfUnmute");
            }
            return "Cannot build ExportGroupCallInvite, attribute initializers form cycle " + attributes;
        }
    }
}

