/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.GetGroupCall;

public final class ImmutableGetGroupCall
implements GetGroupCall {
    private final int identifier;
    private final InputGroupCall call;
    private final int limit;

    private ImmutableGetGroupCall(InputGroupCall call, int limit) {
        this.call = Objects.requireNonNull(call, "call");
        this.limit = limit;
        this.identifier = GetGroupCall.super.identifier();
    }

    private ImmutableGetGroupCall(Builder builder) {
        this.call = builder.call;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetGroupCall.super.identifier();
    }

    private ImmutableGetGroupCall(int identifier, InputGroupCall call, int limit) {
        this.identifier = identifier;
        this.call = call;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetGroupCall(value, this.call, this.limit);
    }

    public final ImmutableGetGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableGetGroupCall(this.identifier, newValue, this.limit);
    }

    public final ImmutableGetGroupCall withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetGroupCall(this.identifier, this.call, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetGroupCall && this.equalTo(0, (ImmutableGetGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetGroupCall another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetGroupCall{identifier=" + this.identifier + ", call=" + this.call + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetGroupCall of(InputGroupCall call, int limit) {
        return new ImmutableGetGroupCall(call, limit);
    }

    public static ImmutableGetGroupCall copyOf(GetGroupCall instance) {
        if (instance instanceof ImmutableGetGroupCall) {
            return (ImmutableGetGroupCall)instance;
        }
        return ImmutableGetGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetGroupCall instance;
            long bits = 0L;
            if (object instanceof GetGroupCall) {
                instance = (GetGroupCall)object;
                this.call(instance.call());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetGroupCall, some of required attributes are not set " + attributes;
        }
    }
}

