/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.GetGroupCallStreamChannels;

public final class ImmutableGetGroupCallStreamChannels
implements GetGroupCallStreamChannels {
    private final int identifier;
    private final InputGroupCall call;

    private ImmutableGetGroupCallStreamChannels(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.identifier = GetGroupCallStreamChannels.super.identifier();
    }

    private ImmutableGetGroupCallStreamChannels(Builder builder) {
        this.call = builder.call;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetGroupCallStreamChannels.super.identifier();
    }

    private ImmutableGetGroupCallStreamChannels(int identifier, InputGroupCall call) {
        this.identifier = identifier;
        this.call = call;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    public final ImmutableGetGroupCallStreamChannels withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetGroupCallStreamChannels(value, this.call);
    }

    public final ImmutableGetGroupCallStreamChannels withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableGetGroupCallStreamChannels(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetGroupCallStreamChannels && this.equalTo(0, (ImmutableGetGroupCallStreamChannels)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetGroupCallStreamChannels another) {
        return this.identifier == another.identifier && this.call.equals(another.call);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        return h;
    }

    public String toString() {
        return "GetGroupCallStreamChannels{identifier=" + this.identifier + ", call=" + this.call + "}";
    }

    public static ImmutableGetGroupCallStreamChannels of(InputGroupCall call) {
        return new ImmutableGetGroupCallStreamChannels(call);
    }

    public static ImmutableGetGroupCallStreamChannels copyOf(GetGroupCallStreamChannels instance) {
        if (instance instanceof ImmutableGetGroupCallStreamChannels) {
            return (ImmutableGetGroupCallStreamChannels)instance;
        }
        return ImmutableGetGroupCallStreamChannels.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetGroupCallStreamChannels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetGroupCallStreamChannels) {
                instance = (GetGroupCallStreamChannels)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetGroupCallStreamChannels build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetGroupCallStreamChannels(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build GetGroupCallStreamChannels, some of required attributes are not set " + attributes;
        }
    }
}

