/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.GetGroupCallStreamRtmpUrl;

public final class ImmutableGetGroupCallStreamRtmpUrl
implements GetGroupCallStreamRtmpUrl {
    private final int identifier;
    private final InputPeer peer;
    private final boolean revoke;

    private ImmutableGetGroupCallStreamRtmpUrl(InputPeer peer, boolean revoke) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.revoke = revoke;
        this.identifier = GetGroupCallStreamRtmpUrl.super.identifier();
    }

    private ImmutableGetGroupCallStreamRtmpUrl(Builder builder) {
        this.peer = builder.peer;
        this.revoke = builder.revoke;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetGroupCallStreamRtmpUrl.super.identifier();
    }

    private ImmutableGetGroupCallStreamRtmpUrl(int identifier, InputPeer peer, boolean revoke) {
        this.identifier = identifier;
        this.peer = peer;
        this.revoke = revoke;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public boolean revoke() {
        return this.revoke;
    }

    public final ImmutableGetGroupCallStreamRtmpUrl withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetGroupCallStreamRtmpUrl(value, this.peer, this.revoke);
    }

    public final ImmutableGetGroupCallStreamRtmpUrl withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetGroupCallStreamRtmpUrl(this.identifier, newValue, this.revoke);
    }

    public final ImmutableGetGroupCallStreamRtmpUrl withRevoke(boolean value) {
        if (this.revoke == value) {
            return this;
        }
        return new ImmutableGetGroupCallStreamRtmpUrl(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetGroupCallStreamRtmpUrl && this.equalTo(0, (ImmutableGetGroupCallStreamRtmpUrl)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetGroupCallStreamRtmpUrl another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.revoke == another.revoke;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Boolean.hashCode(this.revoke);
        return h;
    }

    public String toString() {
        return "GetGroupCallStreamRtmpUrl{identifier=" + this.identifier + ", peer=" + this.peer + ", revoke=" + this.revoke + "}";
    }

    public static ImmutableGetGroupCallStreamRtmpUrl of(InputPeer peer, boolean revoke) {
        return new ImmutableGetGroupCallStreamRtmpUrl(peer, revoke);
    }

    public static ImmutableGetGroupCallStreamRtmpUrl copyOf(GetGroupCallStreamRtmpUrl instance) {
        if (instance instanceof ImmutableGetGroupCallStreamRtmpUrl) {
            return (ImmutableGetGroupCallStreamRtmpUrl)instance;
        }
        return ImmutableGetGroupCallStreamRtmpUrl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_REVOKE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private boolean revoke;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetGroupCallStreamRtmpUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetGroupCallStreamRtmpUrl) {
                instance = (GetGroupCallStreamRtmpUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.revoke(instance.revoke());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder revoke(boolean revoke) {
            this.revoke = revoke;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetGroupCallStreamRtmpUrl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetGroupCallStreamRtmpUrl(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("revoke");
            }
            return "Cannot build GetGroupCallStreamRtmpUrl, some of required attributes are not set " + attributes;
        }
    }
}

