/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.GetGroupParticipants;

public final class ImmutableGetGroupParticipants
implements GetGroupParticipants {
    private final int identifier;
    private final InputGroupCall call;
    private final List<InputPeer> ids;
    private final List<Integer> sources;
    private final String offset;
    private final int limit;

    private ImmutableGetGroupParticipants(InputGroupCall call, String offset, int limit) {
        this.call = Objects.requireNonNull(call, "call");
        this.offset = Objects.requireNonNull(offset, "offset");
        this.limit = limit;
        this.ids = Collections.emptyList();
        this.sources = Collections.emptyList();
        this.identifier = GetGroupParticipants.super.identifier();
    }

    private ImmutableGetGroupParticipants(Builder builder) {
        this.call = builder.call;
        this.ids = ImmutableGetGroupParticipants.createUnmodifiableList(true, builder.ids);
        this.sources = ImmutableGetGroupParticipants.createUnmodifiableList(true, builder.sources);
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetGroupParticipants.super.identifier();
    }

    private ImmutableGetGroupParticipants(int identifier, InputGroupCall call, List<InputPeer> ids, List<Integer> sources, String offset, int limit) {
        this.identifier = identifier;
        this.call = call;
        this.ids = ids;
        this.sources = sources;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public List<InputPeer> ids() {
        return this.ids;
    }

    @Override
    public List<Integer> sources() {
        return this.sources;
    }

    @Override
    public String offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetGroupParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetGroupParticipants(value, this.call, this.ids, this.sources, this.offset, this.limit);
    }

    public final ImmutableGetGroupParticipants withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableGetGroupParticipants(this.identifier, newValue, this.ids, this.sources, this.offset, this.limit);
    }

    public final ImmutableGetGroupParticipants withIds(InputPeer ... elements) {
        List<InputPeer> newValue = ImmutableGetGroupParticipants.createUnmodifiableList(false, ImmutableGetGroupParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetGroupParticipants(this.identifier, this.call, newValue, this.sources, this.offset, this.limit);
    }

    public final ImmutableGetGroupParticipants withIds(Iterable<? extends InputPeer> elements) {
        if (this.ids == elements) {
            return this;
        }
        List<InputPeer> newValue = ImmutableGetGroupParticipants.createUnmodifiableList(false, ImmutableGetGroupParticipants.createSafeList(elements, true, false));
        return new ImmutableGetGroupParticipants(this.identifier, this.call, newValue, this.sources, this.offset, this.limit);
    }

    public final ImmutableGetGroupParticipants withSources(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableGetGroupParticipants.createUnmodifiableList(false, wrappedList);
        return new ImmutableGetGroupParticipants(this.identifier, this.call, this.ids, newValue, this.offset, this.limit);
    }

    public final ImmutableGetGroupParticipants withSources(Iterable<Integer> elements) {
        if (this.sources == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableGetGroupParticipants.createUnmodifiableList(false, ImmutableGetGroupParticipants.createSafeList(elements, true, false));
        return new ImmutableGetGroupParticipants(this.identifier, this.call, this.ids, newValue, this.offset, this.limit);
    }

    public final ImmutableGetGroupParticipants withOffset(String value) {
        String newValue = Objects.requireNonNull(value, "offset");
        if (this.offset.equals(newValue)) {
            return this;
        }
        return new ImmutableGetGroupParticipants(this.identifier, this.call, this.ids, this.sources, newValue, this.limit);
    }

    public final ImmutableGetGroupParticipants withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetGroupParticipants(this.identifier, this.call, this.ids, this.sources, this.offset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetGroupParticipants && this.equalTo(0, (ImmutableGetGroupParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetGroupParticipants another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.ids.equals(another.ids) && this.sources.equals(another.sources) && this.offset.equals(another.offset) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.ids.hashCode();
        h += (h << 5) + this.sources.hashCode();
        h += (h << 5) + this.offset.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetGroupParticipants{identifier=" + this.identifier + ", call=" + this.call + ", ids=" + this.ids + ", sources=" + this.sources + ", offset=" + this.offset + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetGroupParticipants of(InputGroupCall call, String offset, int limit) {
        return new ImmutableGetGroupParticipants(call, offset, limit);
    }

    public static ImmutableGetGroupParticipants copyOf(GetGroupParticipants instance) {
        if (instance instanceof ImmutableGetGroupParticipants) {
            return (ImmutableGetGroupParticipants)instance;
        }
        return ImmutableGetGroupParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_OFFSET = 2L;
        private static final long INIT_BIT_LIMIT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private List<InputPeer> ids = new ArrayList<InputPeer>();
        private List<Integer> sources = new ArrayList<Integer>();
        private String offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetGroupParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetGroupParticipants) {
                instance = (GetGroupParticipants)object;
                this.call(instance.call());
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllIds(instance.ids());
                this.addAllSources(instance.sources());
                this.offset(instance.offset());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addId(InputPeer element) {
            this.ids.add(Objects.requireNonNull(element, "ids element"));
            return this;
        }

        public final Builder addIds(InputPeer ... elements) {
            for (InputPeer element : elements) {
                this.ids.add(Objects.requireNonNull(element, "ids element"));
            }
            return this;
        }

        public final Builder ids(Iterable<? extends InputPeer> elements) {
            this.ids.clear();
            return this.addAllIds(elements);
        }

        public final Builder addAllIds(Iterable<? extends InputPeer> elements) {
            for (InputPeer inputPeer : elements) {
                this.ids.add(Objects.requireNonNull(inputPeer, "ids element"));
            }
            return this;
        }

        public final Builder addSource(int element) {
            this.sources.add(element);
            return this;
        }

        public final Builder addSources(int ... elements) {
            for (int element : elements) {
                this.sources.add(element);
            }
            return this;
        }

        public final Builder sources(Iterable<Integer> elements) {
            this.sources.clear();
            return this.addAllSources(elements);
        }

        public final Builder addAllSources(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.sources.add(Objects.requireNonNull(element, "sources element"));
            }
            return this;
        }

        public final Builder offset(String offset) {
            this.offset = Objects.requireNonNull(offset, "offset");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetGroupParticipants build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetGroupParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetGroupParticipants, some of required attributes are not set " + attributes;
        }
    }
}

