/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.InviteToGroupCall;

public final class ImmutableInviteToGroupCall
implements InviteToGroupCall {
    private final int identifier;
    private final InputGroupCall call;
    private final List<InputUser> users;

    private ImmutableInviteToGroupCall(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.users = Collections.emptyList();
        this.identifier = InviteToGroupCall.super.identifier();
    }

    private ImmutableInviteToGroupCall(Builder builder) {
        this.call = builder.call;
        this.users = ImmutableInviteToGroupCall.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : InviteToGroupCall.super.identifier();
    }

    private ImmutableInviteToGroupCall(int identifier, InputGroupCall call, List<InputUser> users) {
        this.identifier = identifier;
        this.call = call;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public List<InputUser> users() {
        return this.users;
    }

    public final ImmutableInviteToGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInviteToGroupCall(value, this.call, this.users);
    }

    public final ImmutableInviteToGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableInviteToGroupCall(this.identifier, newValue, this.users);
    }

    public final ImmutableInviteToGroupCall withUsers(InputUser ... elements) {
        List<InputUser> newValue = ImmutableInviteToGroupCall.createUnmodifiableList(false, ImmutableInviteToGroupCall.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInviteToGroupCall(this.identifier, this.call, newValue);
    }

    public final ImmutableInviteToGroupCall withUsers(Iterable<? extends InputUser> elements) {
        if (this.users == elements) {
            return this;
        }
        List<InputUser> newValue = ImmutableInviteToGroupCall.createUnmodifiableList(false, ImmutableInviteToGroupCall.createSafeList(elements, true, false));
        return new ImmutableInviteToGroupCall(this.identifier, this.call, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInviteToGroupCall && this.equalTo(0, (ImmutableInviteToGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableInviteToGroupCall another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "InviteToGroupCall{identifier=" + this.identifier + ", call=" + this.call + ", users=" + this.users + "}";
    }

    public static ImmutableInviteToGroupCall of(InputGroupCall call) {
        return new ImmutableInviteToGroupCall(call);
    }

    public static ImmutableInviteToGroupCall copyOf(InviteToGroupCall instance) {
        if (instance instanceof ImmutableInviteToGroupCall) {
            return (ImmutableInviteToGroupCall)instance;
        }
        return ImmutableInviteToGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private List<InputUser> users = new ArrayList<InputUser>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InviteToGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InviteToGroupCall) {
                instance = (InviteToGroupCall)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(InputUser element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(InputUser ... elements) {
            for (InputUser element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends InputUser> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends InputUser> elements) {
            for (InputUser inputUser : elements) {
                this.users.add(Objects.requireNonNull(inputUser, "users element"));
            }
            return this;
        }

        public ImmutableInviteToGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInviteToGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build InviteToGroupCall, some of required attributes are not set " + attributes;
        }
    }
}

