/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.JoinGroupCall;

public final class ImmutableJoinGroupCall
implements JoinGroupCall {
    private final int identifier;
    private final int flags;
    private final boolean muted;
    private final boolean videoStopped;
    private final InputGroupCall call;
    private final InputPeer joinAs;
    @Nullable
    private final String inviteHash;
    private final DataJSON params;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJoinGroupCall(InputGroupCall call, InputPeer joinAs, DataJSON params) {
        this.call = Objects.requireNonNull(call, "call");
        this.joinAs = Objects.requireNonNull(joinAs, "joinAs");
        this.params = Objects.requireNonNull(params, "params");
        this.inviteHash = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.muted = this.initShim.muted();
        this.videoStopped = this.initShim.videoStopped();
        this.initShim = null;
    }

    private ImmutableJoinGroupCall(Builder builder) {
        this.call = builder.call;
        this.joinAs = builder.joinAs;
        this.inviteHash = builder.inviteHash;
        this.params = builder.params;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.mutedIsSet()) {
            this.initShim.muted(builder.muted);
        }
        if (builder.videoStoppedIsSet()) {
            this.initShim.videoStopped(builder.videoStopped);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.muted = this.initShim.muted();
        this.videoStopped = this.initShim.videoStopped();
        this.initShim = null;
    }

    private ImmutableJoinGroupCall(int identifier, int flags, boolean muted, boolean videoStopped, InputGroupCall call, InputPeer joinAs, @Nullable String inviteHash, DataJSON params) {
        this.identifier = identifier;
        this.flags = flags;
        this.muted = muted;
        this.videoStopped = videoStopped;
        this.call = call;
        this.joinAs = joinAs;
        this.inviteHash = inviteHash;
        this.params = params;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return JoinGroupCall.super.identifier();
    }

    private int flagsInitialize() {
        return JoinGroupCall.super.flags();
    }

    private boolean mutedInitialize() {
        return JoinGroupCall.super.muted();
    }

    private boolean videoStoppedInitialize() {
        return JoinGroupCall.super.videoStopped();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean muted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.muted() : this.muted;
    }

    @Override
    public boolean videoStopped() {
        InitShim shim = this.initShim;
        return shim != null ? shim.videoStopped() : this.videoStopped;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public InputPeer joinAs() {
        return this.joinAs;
    }

    @Override
    @Nullable
    public String inviteHash() {
        return this.inviteHash;
    }

    @Override
    public DataJSON params() {
        return this.params;
    }

    public final ImmutableJoinGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableJoinGroupCall(value, this.flags, this.muted, this.videoStopped, this.call, this.joinAs, this.inviteHash, this.params);
    }

    public final ImmutableJoinGroupCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableJoinGroupCall(this.identifier, value, this.muted, this.videoStopped, this.call, this.joinAs, this.inviteHash, this.params);
    }

    public final ImmutableJoinGroupCall withMuted(boolean value) {
        if (this.muted == value) {
            return this;
        }
        return new ImmutableJoinGroupCall(this.identifier, this.flags, value, this.videoStopped, this.call, this.joinAs, this.inviteHash, this.params);
    }

    public final ImmutableJoinGroupCall withVideoStopped(boolean value) {
        if (this.videoStopped == value) {
            return this;
        }
        return new ImmutableJoinGroupCall(this.identifier, this.flags, this.muted, value, this.call, this.joinAs, this.inviteHash, this.params);
    }

    public final ImmutableJoinGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableJoinGroupCall(this.identifier, this.flags, this.muted, this.videoStopped, newValue, this.joinAs, this.inviteHash, this.params);
    }

    public final ImmutableJoinGroupCall withJoinAs(InputPeer value) {
        if (this.joinAs == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "joinAs");
        return new ImmutableJoinGroupCall(this.identifier, this.flags, this.muted, this.videoStopped, this.call, newValue, this.inviteHash, this.params);
    }

    public final ImmutableJoinGroupCall withInviteHash(@Nullable String value) {
        if (Objects.equals(this.inviteHash, value)) {
            return this;
        }
        return new ImmutableJoinGroupCall(this.identifier, this.flags, this.muted, this.videoStopped, this.call, this.joinAs, value, this.params);
    }

    public final ImmutableJoinGroupCall withParams(DataJSON value) {
        if (this.params == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "params");
        return new ImmutableJoinGroupCall(this.identifier, this.flags, this.muted, this.videoStopped, this.call, this.joinAs, this.inviteHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoinGroupCall && this.equalTo(0, (ImmutableJoinGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableJoinGroupCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.muted == another.muted && this.videoStopped == another.videoStopped && this.call.equals(another.call) && this.joinAs.equals(another.joinAs) && Objects.equals(this.inviteHash, another.inviteHash) && this.params.equals(another.params);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.muted);
        h += (h << 5) + Boolean.hashCode(this.videoStopped);
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.joinAs.hashCode();
        h += (h << 5) + Objects.hashCode(this.inviteHash);
        h += (h << 5) + this.params.hashCode();
        return h;
    }

    public String toString() {
        return "JoinGroupCall{identifier=" + this.identifier + ", flags=" + this.flags + ", muted=" + this.muted + ", videoStopped=" + this.videoStopped + ", call=" + this.call + ", joinAs=" + this.joinAs + ", inviteHash=" + this.inviteHash + ", params=" + this.params + "}";
    }

    public static ImmutableJoinGroupCall of(InputGroupCall call, InputPeer joinAs, DataJSON params) {
        return new ImmutableJoinGroupCall(call, joinAs, params);
    }

    public static ImmutableJoinGroupCall copyOf(JoinGroupCall instance) {
        if (instance instanceof ImmutableJoinGroupCall) {
            return (ImmutableJoinGroupCall)instance;
        }
        return ImmutableJoinGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_JOIN_AS = 2L;
        private static final long INIT_BIT_PARAMS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MUTED = 4L;
        private static final long OPT_BIT_VIDEO_STOPPED = 8L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean muted;
        private boolean videoStopped;
        private InputGroupCall call;
        private InputPeer joinAs;
        private String inviteHash;
        private DataJSON params;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JoinGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof JoinGroupCall) {
                instance = (JoinGroupCall)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.joinAs(instance.joinAs());
                String inviteHashValue = instance.inviteHash();
                if (inviteHashValue != null) {
                    this.inviteHash(inviteHashValue);
                }
                this.flags(instance.flags());
                this.videoStopped(instance.videoStopped());
                this.params(instance.params());
                this.muted(instance.muted());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder muted(boolean muted) {
            this.muted = muted;
            this.optBits |= 4L;
            return this;
        }

        public final Builder videoStopped(boolean videoStopped) {
            this.videoStopped = videoStopped;
            this.optBits |= 8L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder joinAs(InputPeer joinAs) {
            this.joinAs = Objects.requireNonNull(joinAs, "joinAs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder inviteHash(@Nullable String inviteHash) {
            this.inviteHash = inviteHash;
            return this;
        }

        public final Builder params(DataJSON params) {
            this.params = Objects.requireNonNull(params, "params");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableJoinGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJoinGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean mutedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean videoStoppedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("joinAs");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("params");
            }
            return "Cannot build JoinGroupCall, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte mutedBuildStage = 0;
        private boolean muted;
        private byte videoStoppedBuildStage = 0;
        private boolean videoStopped;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableJoinGroupCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableJoinGroupCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean muted() {
            if (this.mutedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mutedBuildStage == 0) {
                this.mutedBuildStage = (byte)-1;
                this.muted = ImmutableJoinGroupCall.this.mutedInitialize();
                this.mutedBuildStage = 1;
            }
            return this.muted;
        }

        void muted(boolean muted) {
            this.muted = muted;
            this.mutedBuildStage = 1;
        }

        boolean videoStopped() {
            if (this.videoStoppedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoStoppedBuildStage == 0) {
                this.videoStoppedBuildStage = (byte)-1;
                this.videoStopped = ImmutableJoinGroupCall.this.videoStoppedInitialize();
                this.videoStoppedBuildStage = 1;
            }
            return this.videoStopped;
        }

        void videoStopped(boolean videoStopped) {
            this.videoStopped = videoStopped;
            this.videoStoppedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.mutedBuildStage == -1) {
                attributes.add("muted");
            }
            if (this.videoStoppedBuildStage == -1) {
                attributes.add("videoStopped");
            }
            return "Cannot build JoinGroupCall, attribute initializers form cycle " + attributes;
        }
    }
}

