/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.JoinGroupCallPresentation;

public final class ImmutableJoinGroupCallPresentation
implements JoinGroupCallPresentation {
    private final int identifier;
    private final InputGroupCall call;
    private final DataJSON params;

    private ImmutableJoinGroupCallPresentation(InputGroupCall call, DataJSON params) {
        this.call = Objects.requireNonNull(call, "call");
        this.params = Objects.requireNonNull(params, "params");
        this.identifier = JoinGroupCallPresentation.super.identifier();
    }

    private ImmutableJoinGroupCallPresentation(Builder builder) {
        this.call = builder.call;
        this.params = builder.params;
        this.identifier = builder.identifierIsSet() ? builder.identifier : JoinGroupCallPresentation.super.identifier();
    }

    private ImmutableJoinGroupCallPresentation(int identifier, InputGroupCall call, DataJSON params) {
        this.identifier = identifier;
        this.call = call;
        this.params = params;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public DataJSON params() {
        return this.params;
    }

    public final ImmutableJoinGroupCallPresentation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableJoinGroupCallPresentation(value, this.call, this.params);
    }

    public final ImmutableJoinGroupCallPresentation withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableJoinGroupCallPresentation(this.identifier, newValue, this.params);
    }

    public final ImmutableJoinGroupCallPresentation withParams(DataJSON value) {
        if (this.params == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "params");
        return new ImmutableJoinGroupCallPresentation(this.identifier, this.call, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoinGroupCallPresentation && this.equalTo(0, (ImmutableJoinGroupCallPresentation)another);
    }

    private boolean equalTo(int synthetic, ImmutableJoinGroupCallPresentation another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.params.equals(another.params);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.params.hashCode();
        return h;
    }

    public String toString() {
        return "JoinGroupCallPresentation{identifier=" + this.identifier + ", call=" + this.call + ", params=" + this.params + "}";
    }

    public static ImmutableJoinGroupCallPresentation of(InputGroupCall call, DataJSON params) {
        return new ImmutableJoinGroupCallPresentation(call, params);
    }

    public static ImmutableJoinGroupCallPresentation copyOf(JoinGroupCallPresentation instance) {
        if (instance instanceof ImmutableJoinGroupCallPresentation) {
            return (ImmutableJoinGroupCallPresentation)instance;
        }
        return ImmutableJoinGroupCallPresentation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_PARAMS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private DataJSON params;

        private Builder() {
        }

        public final Builder from(JoinGroupCallPresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            JoinGroupCallPresentation instance;
            long bits = 0L;
            if (object instanceof JoinGroupCallPresentation) {
                instance = (JoinGroupCallPresentation)object;
                this.call(instance.call());
                this.params(instance.params());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder params(DataJSON params) {
            this.params = Objects.requireNonNull(params, "params");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableJoinGroupCallPresentation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJoinGroupCallPresentation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("params");
            }
            return "Cannot build JoinGroupCallPresentation, some of required attributes are not set " + attributes;
        }
    }
}

