/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.LeaveGroupCall;

public final class ImmutableLeaveGroupCall
implements LeaveGroupCall {
    private final int identifier;
    private final InputGroupCall call;
    private final int source;

    private ImmutableLeaveGroupCall(InputGroupCall call, int source) {
        this.call = Objects.requireNonNull(call, "call");
        this.source = source;
        this.identifier = LeaveGroupCall.super.identifier();
    }

    private ImmutableLeaveGroupCall(Builder builder) {
        this.call = builder.call;
        this.source = builder.source;
        this.identifier = builder.identifierIsSet() ? builder.identifier : LeaveGroupCall.super.identifier();
    }

    private ImmutableLeaveGroupCall(int identifier, InputGroupCall call, int source) {
        this.identifier = identifier;
        this.call = call;
        this.source = source;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public int source() {
        return this.source;
    }

    public final ImmutableLeaveGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLeaveGroupCall(value, this.call, this.source);
    }

    public final ImmutableLeaveGroupCall withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableLeaveGroupCall(this.identifier, newValue, this.source);
    }

    public final ImmutableLeaveGroupCall withSource(int value) {
        if (this.source == value) {
            return this;
        }
        return new ImmutableLeaveGroupCall(this.identifier, this.call, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLeaveGroupCall && this.equalTo(0, (ImmutableLeaveGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableLeaveGroupCall another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.source == another.source;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.source;
        return h;
    }

    public String toString() {
        return "LeaveGroupCall{identifier=" + this.identifier + ", call=" + this.call + ", source=" + this.source + "}";
    }

    public static ImmutableLeaveGroupCall of(InputGroupCall call, int source) {
        return new ImmutableLeaveGroupCall(call, source);
    }

    public static ImmutableLeaveGroupCall copyOf(LeaveGroupCall instance) {
        if (instance instanceof ImmutableLeaveGroupCall) {
            return (ImmutableLeaveGroupCall)instance;
        }
        return ImmutableLeaveGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_SOURCE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private int source;

        private Builder() {
        }

        public final Builder from(LeaveGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LeaveGroupCall instance;
            long bits = 0L;
            if (object instanceof LeaveGroupCall) {
                instance = (LeaveGroupCall)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.source(instance.source());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder source(int source) {
            this.source = source;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLeaveGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLeaveGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("source");
            }
            return "Cannot build LeaveGroupCall, some of required attributes are not set " + attributes;
        }
    }
}

