/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.LeaveGroupCallPresentation;

public final class ImmutableLeaveGroupCallPresentation
implements LeaveGroupCallPresentation {
    private final int identifier;
    private final InputGroupCall call;

    private ImmutableLeaveGroupCallPresentation(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.identifier = LeaveGroupCallPresentation.super.identifier();
    }

    private ImmutableLeaveGroupCallPresentation(Builder builder) {
        this.call = builder.call;
        this.identifier = builder.identifierIsSet() ? builder.identifier : LeaveGroupCallPresentation.super.identifier();
    }

    private ImmutableLeaveGroupCallPresentation(int identifier, InputGroupCall call) {
        this.identifier = identifier;
        this.call = call;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    public final ImmutableLeaveGroupCallPresentation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableLeaveGroupCallPresentation(value, this.call);
    }

    public final ImmutableLeaveGroupCallPresentation withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableLeaveGroupCallPresentation(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLeaveGroupCallPresentation && this.equalTo(0, (ImmutableLeaveGroupCallPresentation)another);
    }

    private boolean equalTo(int synthetic, ImmutableLeaveGroupCallPresentation another) {
        return this.identifier == another.identifier && this.call.equals(another.call);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        return h;
    }

    public String toString() {
        return "LeaveGroupCallPresentation{identifier=" + this.identifier + ", call=" + this.call + "}";
    }

    public static ImmutableLeaveGroupCallPresentation of(InputGroupCall call) {
        return new ImmutableLeaveGroupCallPresentation(call);
    }

    public static ImmutableLeaveGroupCallPresentation copyOf(LeaveGroupCallPresentation instance) {
        if (instance instanceof ImmutableLeaveGroupCallPresentation) {
            return (ImmutableLeaveGroupCallPresentation)instance;
        }
        return ImmutableLeaveGroupCallPresentation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;

        private Builder() {
        }

        public final Builder from(LeaveGroupCallPresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LeaveGroupCallPresentation instance;
            long bits = 0L;
            if (object instanceof LeaveGroupCallPresentation) {
                instance = (LeaveGroupCallPresentation)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableLeaveGroupCallPresentation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLeaveGroupCallPresentation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build LeaveGroupCallPresentation, some of required attributes are not set " + attributes;
        }
    }
}

