/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.ReceivedCall;

public final class ImmutableReceivedCall
implements ReceivedCall {
    private final int identifier;
    private final InputPhoneCall peer;

    private ImmutableReceivedCall(InputPhoneCall peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = ReceivedCall.super.identifier();
    }

    private ImmutableReceivedCall(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReceivedCall.super.identifier();
    }

    private ImmutableReceivedCall(int identifier, InputPhoneCall peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    public final ImmutableReceivedCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReceivedCall(value, this.peer);
    }

    public final ImmutableReceivedCall withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReceivedCall(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReceivedCall && this.equalTo(0, (ImmutableReceivedCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableReceivedCall another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "ReceivedCall{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableReceivedCall of(InputPhoneCall peer) {
        return new ImmutableReceivedCall(peer);
    }

    public static ImmutableReceivedCall copyOf(ReceivedCall instance) {
        if (instance instanceof ImmutableReceivedCall) {
            return (ImmutableReceivedCall)instance;
        }
        return ImmutableReceivedCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPhoneCall peer;

        private Builder() {
        }

        public final Builder from(ReceivedCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReceivedCall instance;
            long bits = 0L;
            if (object instanceof ReceivedCall) {
                instance = (ReceivedCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableReceivedCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReceivedCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ReceivedCall, some of required attributes are not set " + attributes;
        }
    }
}

