/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.PhoneCallProtocol;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.RequestCall;

public final class ImmutableRequestCall
implements RequestCall {
    private final int identifier;
    private final int flags;
    private final boolean video;
    private final InputUser userId;
    private final int randomId;
    private final ByteBuf gAHash;
    private final PhoneCallProtocol protocol;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRequestCall(InputUser userId, int randomId, PhoneCallProtocol protocol) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.randomId = randomId;
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.gAHash = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableRequestCall(Builder builder) {
        this.userId = builder.userId;
        this.randomId = builder.randomId;
        this.gAHash = builder.gAHash_build();
        this.protocol = builder.protocol;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableRequestCall(int identifier, int flags, boolean video, InputUser userId, int randomId, ByteBuf gAHash, PhoneCallProtocol protocol) {
        this.identifier = identifier;
        this.flags = flags;
        this.video = video;
        this.userId = userId;
        this.randomId = randomId;
        this.gAHash = gAHash;
        this.protocol = protocol;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return RequestCall.super.identifier();
    }

    private int flagsInitialize() {
        return RequestCall.super.flags();
    }

    private boolean videoInitialize() {
        return RequestCall.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public int randomId() {
        return this.randomId;
    }

    @Override
    public ByteBuf gAHash() {
        return this.gAHash.duplicate();
    }

    @Override
    public PhoneCallProtocol protocol() {
        return this.protocol;
    }

    public final ImmutableRequestCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRequestCall(value, this.flags, this.video, this.userId, this.randomId, this.gAHash, this.protocol);
    }

    public final ImmutableRequestCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableRequestCall(this.identifier, value, this.video, this.userId, this.randomId, this.gAHash, this.protocol);
    }

    public final ImmutableRequestCall withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutableRequestCall(this.identifier, this.flags, value, this.userId, this.randomId, this.gAHash, this.protocol);
    }

    public final ImmutableRequestCall withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableRequestCall(this.identifier, this.flags, this.video, newValue, this.randomId, this.gAHash, this.protocol);
    }

    public final ImmutableRequestCall withRandomId(int value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableRequestCall(this.identifier, this.flags, this.video, this.userId, value, this.gAHash, this.protocol);
    }

    public ImmutableRequestCall withGAHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gAHash == newValue) {
            return this;
        }
        return new ImmutableRequestCall(this.identifier, this.flags, this.video, this.userId, this.randomId, newValue, this.protocol);
    }

    public final ImmutableRequestCall withProtocol(PhoneCallProtocol value) {
        if (this.protocol == value) {
            return this;
        }
        PhoneCallProtocol newValue = Objects.requireNonNull(value, "protocol");
        return new ImmutableRequestCall(this.identifier, this.flags, this.video, this.userId, this.randomId, this.gAHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequestCall && this.equalTo(0, (ImmutableRequestCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequestCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.video == another.video && this.userId.equals(another.userId) && this.randomId == another.randomId && this.gAHash().equals((Object)another.gAHash()) && this.protocol.equals(another.protocol);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.randomId;
        h += (h << 5) + this.gAHash().hashCode();
        h += (h << 5) + this.protocol.hashCode();
        return h;
    }

    public String toString() {
        return "RequestCall{identifier=" + this.identifier + ", flags=" + this.flags + ", video=" + this.video + ", userId=" + this.userId + ", randomId=" + this.randomId + ", gAHash=" + ByteBufUtil.hexDump((ByteBuf)this.gAHash) + ", protocol=" + this.protocol + "}";
    }

    public static ImmutableRequestCall of(InputUser userId, int randomId, PhoneCallProtocol protocol) {
        return new ImmutableRequestCall(userId, randomId, protocol);
    }

    public static ImmutableRequestCall copyOf(RequestCall instance) {
        if (instance instanceof ImmutableRequestCall) {
            return (ImmutableRequestCall)instance;
        }
        return ImmutableRequestCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long INIT_BIT_PROTOCOL = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_VIDEO = 4L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf gAHash_value = null;
        private int identifier;
        private int flags;
        private boolean video;
        private InputUser userId;
        private int randomId;
        private PhoneCallProtocol protocol;

        private Builder() {
        }

        public final Builder from(RequestCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RequestCall instance;
            long bits = 0L;
            if (object instanceof RequestCall) {
                instance = (RequestCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.gAHash(instance.gAHash());
                this.randomId(instance.randomId());
                this.protocol(instance.protocol());
                this.flags(instance.flags());
                this.video(instance.video());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 4L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(int randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder gAHash(ByteBuf value) {
            this.gAHash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder protocol(PhoneCallProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRequestCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequestCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("protocol");
            }
            return "Cannot build RequestCall, some of required attributes are not set " + attributes;
        }

        private ByteBuf gAHash_build() {
            return Objects.requireNonNull(this.gAHash_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableRequestCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableRequestCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutableRequestCall.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build RequestCall, attribute initializers form cycle " + attributes;
        }
    }
}

