/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.SaveCallDebug;

public final class ImmutableSaveCallDebug
implements SaveCallDebug {
    private final int identifier;
    private final InputPhoneCall peer;
    private final DataJSON debug;

    private ImmutableSaveCallDebug(InputPhoneCall peer, DataJSON debug) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.debug = Objects.requireNonNull(debug, "debug");
        this.identifier = SaveCallDebug.super.identifier();
    }

    private ImmutableSaveCallDebug(Builder builder) {
        this.peer = builder.peer;
        this.debug = builder.debug;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveCallDebug.super.identifier();
    }

    private ImmutableSaveCallDebug(int identifier, InputPhoneCall peer, DataJSON debug) {
        this.identifier = identifier;
        this.peer = peer;
        this.debug = debug;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    @Override
    public DataJSON debug() {
        return this.debug;
    }

    public final ImmutableSaveCallDebug withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveCallDebug(value, this.peer, this.debug);
    }

    public final ImmutableSaveCallDebug withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSaveCallDebug(this.identifier, newValue, this.debug);
    }

    public final ImmutableSaveCallDebug withDebug(DataJSON value) {
        if (this.debug == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "debug");
        return new ImmutableSaveCallDebug(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveCallDebug && this.equalTo(0, (ImmutableSaveCallDebug)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveCallDebug another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.debug.equals(another.debug);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.debug.hashCode();
        return h;
    }

    public String toString() {
        return "SaveCallDebug{identifier=" + this.identifier + ", peer=" + this.peer + ", debug=" + this.debug + "}";
    }

    public static ImmutableSaveCallDebug of(InputPhoneCall peer, DataJSON debug) {
        return new ImmutableSaveCallDebug(peer, debug);
    }

    public static ImmutableSaveCallDebug copyOf(SaveCallDebug instance) {
        if (instance instanceof ImmutableSaveCallDebug) {
            return (ImmutableSaveCallDebug)instance;
        }
        return ImmutableSaveCallDebug.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_DEBUG = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPhoneCall peer;
        private DataJSON debug;

        private Builder() {
        }

        public final Builder from(SaveCallDebug instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveCallDebug instance;
            long bits = 0L;
            if (object instanceof SaveCallDebug) {
                instance = (SaveCallDebug)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.debug(instance.debug());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder debug(DataJSON debug) {
            this.debug = Objects.requireNonNull(debug, "debug");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveCallDebug build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveCallDebug(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("debug");
            }
            return "Cannot build SaveCallDebug, some of required attributes are not set " + attributes;
        }
    }
}

