/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFile;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.SaveCallLog;

public final class ImmutableSaveCallLog
implements SaveCallLog {
    private final int identifier;
    private final InputPhoneCall peer;
    private final InputFile file;

    private ImmutableSaveCallLog(InputPhoneCall peer, InputFile file) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.file = Objects.requireNonNull(file, "file");
        this.identifier = SaveCallLog.super.identifier();
    }

    private ImmutableSaveCallLog(Builder builder) {
        this.peer = builder.peer;
        this.file = builder.file;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveCallLog.super.identifier();
    }

    private ImmutableSaveCallLog(int identifier, InputPhoneCall peer, InputFile file) {
        this.identifier = identifier;
        this.peer = peer;
        this.file = file;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    @Override
    public InputFile file() {
        return this.file;
    }

    public final ImmutableSaveCallLog withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveCallLog(value, this.peer, this.file);
    }

    public final ImmutableSaveCallLog withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSaveCallLog(this.identifier, newValue, this.file);
    }

    public final ImmutableSaveCallLog withFile(InputFile value) {
        if (this.file == value) {
            return this;
        }
        InputFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableSaveCallLog(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveCallLog && this.equalTo(0, (ImmutableSaveCallLog)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveCallLog another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "SaveCallLog{identifier=" + this.identifier + ", peer=" + this.peer + ", file=" + this.file + "}";
    }

    public static ImmutableSaveCallLog of(InputPhoneCall peer, InputFile file) {
        return new ImmutableSaveCallLog(peer, file);
    }

    public static ImmutableSaveCallLog copyOf(SaveCallLog instance) {
        if (instance instanceof ImmutableSaveCallLog) {
            return (ImmutableSaveCallLog)instance;
        }
        return ImmutableSaveCallLog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_FILE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPhoneCall peer;
        private InputFile file;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SaveCallLog instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SaveCallLog) {
                instance = (SaveCallLog)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.file(instance.file());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder file(InputFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveCallLog build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveCallLog(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build SaveCallLog, some of required attributes are not set " + attributes;
        }
    }
}

