/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.SaveDefaultGroupCallJoinAs;

public final class ImmutableSaveDefaultGroupCallJoinAs
implements SaveDefaultGroupCallJoinAs {
    private final int identifier;
    private final InputPeer peer;
    private final InputPeer joinAs;

    private ImmutableSaveDefaultGroupCallJoinAs(InputPeer peer, InputPeer joinAs) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.joinAs = Objects.requireNonNull(joinAs, "joinAs");
        this.identifier = SaveDefaultGroupCallJoinAs.super.identifier();
    }

    private ImmutableSaveDefaultGroupCallJoinAs(Builder builder) {
        this.peer = builder.peer;
        this.joinAs = builder.joinAs;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveDefaultGroupCallJoinAs.super.identifier();
    }

    private ImmutableSaveDefaultGroupCallJoinAs(int identifier, InputPeer peer, InputPeer joinAs) {
        this.identifier = identifier;
        this.peer = peer;
        this.joinAs = joinAs;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputPeer joinAs() {
        return this.joinAs;
    }

    public final ImmutableSaveDefaultGroupCallJoinAs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveDefaultGroupCallJoinAs(value, this.peer, this.joinAs);
    }

    public final ImmutableSaveDefaultGroupCallJoinAs withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSaveDefaultGroupCallJoinAs(this.identifier, newValue, this.joinAs);
    }

    public final ImmutableSaveDefaultGroupCallJoinAs withJoinAs(InputPeer value) {
        if (this.joinAs == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "joinAs");
        return new ImmutableSaveDefaultGroupCallJoinAs(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveDefaultGroupCallJoinAs && this.equalTo(0, (ImmutableSaveDefaultGroupCallJoinAs)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveDefaultGroupCallJoinAs another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.joinAs.equals(another.joinAs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.joinAs.hashCode();
        return h;
    }

    public String toString() {
        return "SaveDefaultGroupCallJoinAs{identifier=" + this.identifier + ", peer=" + this.peer + ", joinAs=" + this.joinAs + "}";
    }

    public static ImmutableSaveDefaultGroupCallJoinAs of(InputPeer peer, InputPeer joinAs) {
        return new ImmutableSaveDefaultGroupCallJoinAs(peer, joinAs);
    }

    public static ImmutableSaveDefaultGroupCallJoinAs copyOf(SaveDefaultGroupCallJoinAs instance) {
        if (instance instanceof ImmutableSaveDefaultGroupCallJoinAs) {
            return (ImmutableSaveDefaultGroupCallJoinAs)instance;
        }
        return ImmutableSaveDefaultGroupCallJoinAs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_JOIN_AS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private InputPeer joinAs;

        private Builder() {
        }

        public final Builder from(SaveDefaultGroupCallJoinAs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveDefaultGroupCallJoinAs instance;
            long bits = 0L;
            if (object instanceof SaveDefaultGroupCallJoinAs) {
                instance = (SaveDefaultGroupCallJoinAs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.joinAs(instance.joinAs());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder joinAs(InputPeer joinAs) {
            this.joinAs = Objects.requireNonNull(joinAs, "joinAs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveDefaultGroupCallJoinAs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveDefaultGroupCallJoinAs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("joinAs");
            }
            return "Cannot build SaveDefaultGroupCallJoinAs, some of required attributes are not set " + attributes;
        }
    }
}

