/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.SendSignalingData;

public final class ImmutableSendSignalingData
implements SendSignalingData {
    private final int identifier;
    private final InputPhoneCall peer;
    private final ByteBuf data;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSendSignalingData(InputPhoneCall peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.data = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSendSignalingData(Builder builder) {
        this.peer = builder.peer;
        this.data = builder.data_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSendSignalingData(int identifier, InputPhoneCall peer, ByteBuf data) {
        this.identifier = identifier;
        this.peer = peer;
        this.data = data;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SendSignalingData.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    @Override
    public ByteBuf data() {
        return this.data.duplicate();
    }

    public final ImmutableSendSignalingData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendSignalingData(value, this.peer, this.data);
    }

    public final ImmutableSendSignalingData withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSendSignalingData(this.identifier, newValue, this.data);
    }

    public ImmutableSendSignalingData withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableSendSignalingData(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendSignalingData && this.equalTo(0, (ImmutableSendSignalingData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendSignalingData another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.data().equals((Object)another.data());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.data().hashCode();
        return h;
    }

    public String toString() {
        return "SendSignalingData{identifier=" + this.identifier + ", peer=" + this.peer + ", data=" + ByteBufUtil.hexDump((ByteBuf)this.data) + "}";
    }

    public static ImmutableSendSignalingData of(InputPhoneCall peer) {
        return new ImmutableSendSignalingData(peer);
    }

    public static ImmutableSendSignalingData copyOf(SendSignalingData instance) {
        if (instance instanceof ImmutableSendSignalingData) {
            return (ImmutableSendSignalingData)instance;
        }
        return ImmutableSendSignalingData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf data_value = null;
        private int identifier;
        private InputPhoneCall peer;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendSignalingData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendSignalingData) {
                instance = (SendSignalingData)object;
                this.data(instance.data());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder data(ByteBuf value) {
            this.data_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSendSignalingData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendSignalingData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build SendSignalingData, some of required attributes are not set " + attributes;
        }

        private ByteBuf data_build() {
            return Objects.requireNonNull(this.data_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSendSignalingData.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SendSignalingData, attribute initializers form cycle " + attributes;
        }
    }
}

