/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoneCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.SetCallRating;

public final class ImmutableSetCallRating
implements SetCallRating {
    private final int identifier;
    private final int flags;
    private final boolean userInitiative;
    private final InputPhoneCall peer;
    private final int rating;
    private final String comment;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSetCallRating(InputPhoneCall peer, int rating, String comment) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.rating = rating;
        this.comment = Objects.requireNonNull(comment, "comment");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.userInitiative = this.initShim.userInitiative();
        this.initShim = null;
    }

    private ImmutableSetCallRating(Builder builder) {
        this.peer = builder.peer;
        this.rating = builder.rating;
        this.comment = builder.comment;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.userInitiativeIsSet()) {
            this.initShim.userInitiative(builder.userInitiative);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.userInitiative = this.initShim.userInitiative();
        this.initShim = null;
    }

    private ImmutableSetCallRating(int identifier, int flags, boolean userInitiative, InputPhoneCall peer, int rating, String comment) {
        this.identifier = identifier;
        this.flags = flags;
        this.userInitiative = userInitiative;
        this.peer = peer;
        this.rating = rating;
        this.comment = comment;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetCallRating.super.identifier();
    }

    private int flagsInitialize() {
        return SetCallRating.super.flags();
    }

    private boolean userInitiativeInitialize() {
        return SetCallRating.super.userInitiative();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean userInitiative() {
        InitShim shim = this.initShim;
        return shim != null ? shim.userInitiative() : this.userInitiative;
    }

    @Override
    public InputPhoneCall peer() {
        return this.peer;
    }

    @Override
    public int rating() {
        return this.rating;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public final ImmutableSetCallRating withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetCallRating(value, this.flags, this.userInitiative, this.peer, this.rating, this.comment);
    }

    public final ImmutableSetCallRating withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSetCallRating(this.identifier, value, this.userInitiative, this.peer, this.rating, this.comment);
    }

    public final ImmutableSetCallRating withUserInitiative(boolean value) {
        if (this.userInitiative == value) {
            return this;
        }
        return new ImmutableSetCallRating(this.identifier, this.flags, value, this.peer, this.rating, this.comment);
    }

    public final ImmutableSetCallRating withPeer(InputPhoneCall value) {
        if (this.peer == value) {
            return this;
        }
        InputPhoneCall newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableSetCallRating(this.identifier, this.flags, this.userInitiative, newValue, this.rating, this.comment);
    }

    public final ImmutableSetCallRating withRating(int value) {
        if (this.rating == value) {
            return this;
        }
        return new ImmutableSetCallRating(this.identifier, this.flags, this.userInitiative, this.peer, value, this.comment);
    }

    public final ImmutableSetCallRating withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (this.comment.equals(newValue)) {
            return this;
        }
        return new ImmutableSetCallRating(this.identifier, this.flags, this.userInitiative, this.peer, this.rating, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetCallRating && this.equalTo(0, (ImmutableSetCallRating)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetCallRating another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.userInitiative == another.userInitiative && this.peer.equals(another.peer) && this.rating == another.rating && this.comment.equals(another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.userInitiative);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.rating;
        h += (h << 5) + this.comment.hashCode();
        return h;
    }

    public String toString() {
        return "SetCallRating{identifier=" + this.identifier + ", flags=" + this.flags + ", userInitiative=" + this.userInitiative + ", peer=" + this.peer + ", rating=" + this.rating + ", comment=" + this.comment + "}";
    }

    public static ImmutableSetCallRating of(InputPhoneCall peer, int rating, String comment) {
        return new ImmutableSetCallRating(peer, rating, comment);
    }

    public static ImmutableSetCallRating copyOf(SetCallRating instance) {
        if (instance instanceof ImmutableSetCallRating) {
            return (ImmutableSetCallRating)instance;
        }
        return ImmutableSetCallRating.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_RATING = 2L;
        private static final long INIT_BIT_COMMENT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_USER_INITIATIVE = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean userInitiative;
        private InputPhoneCall peer;
        private int rating;
        private String comment;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetCallRating instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetCallRating) {
                instance = (SetCallRating)object;
                this.flags(instance.flags());
                this.rating(instance.rating());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.comment(instance.comment());
                this.peer(instance.peer());
                this.userInitiative(instance.userInitiative());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder userInitiative(boolean userInitiative) {
            this.userInitiative = userInitiative;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPhoneCall peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rating(int rating) {
            this.rating = rating;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSetCallRating build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetCallRating(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean userInitiativeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rating");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("comment");
            }
            return "Cannot build SetCallRating, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte userInitiativeBuildStage = 0;
        private boolean userInitiative;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetCallRating.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetCallRating.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean userInitiative() {
            if (this.userInitiativeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userInitiativeBuildStage == 0) {
                this.userInitiativeBuildStage = (byte)-1;
                this.userInitiative = ImmutableSetCallRating.this.userInitiativeInitialize();
                this.userInitiativeBuildStage = 1;
            }
            return this.userInitiative;
        }

        void userInitiative(boolean userInitiative) {
            this.userInitiative = userInitiative;
            this.userInitiativeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.userInitiativeBuildStage == -1) {
                attributes.add("userInitiative");
            }
            return "Cannot build SetCallRating, attribute initializers form cycle " + attributes;
        }
    }
}

