/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.ToggleGroupCallRecord;

public final class ImmutableToggleGroupCallRecord
implements ToggleGroupCallRecord {
    private final int identifier;
    private final int flags;
    private final boolean start;
    private final boolean video;
    private final InputGroupCall call;
    @Nullable
    private final String title;
    @Nullable
    private final Boolean videoPortrait;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableToggleGroupCallRecord(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.title = null;
        this.videoPortrait = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.start = this.initShim.start();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableToggleGroupCallRecord(Builder builder) {
        this.call = builder.call;
        this.title = builder.title;
        this.videoPortrait = builder.videoPortrait;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.startIsSet()) {
            this.initShim.start(builder.start);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.start = this.initShim.start();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableToggleGroupCallRecord(int identifier, int flags, boolean start, boolean video, InputGroupCall call, @Nullable String title, @Nullable Boolean videoPortrait) {
        this.identifier = identifier;
        this.flags = flags;
        this.start = start;
        this.video = video;
        this.call = call;
        this.title = title;
        this.videoPortrait = videoPortrait;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ToggleGroupCallRecord.super.identifier();
    }

    private int flagsInitialize() {
        return ToggleGroupCallRecord.super.flags();
    }

    private boolean startInitialize() {
        return ToggleGroupCallRecord.super.start();
    }

    private boolean videoInitialize() {
        return ToggleGroupCallRecord.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean start() {
        InitShim shim = this.initShim;
        return shim != null ? shim.start() : this.start;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public Boolean videoPortrait() {
        return this.videoPortrait;
    }

    public final ImmutableToggleGroupCallRecord withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleGroupCallRecord(value, this.flags, this.start, this.video, this.call, this.title, this.videoPortrait);
    }

    public final ImmutableToggleGroupCallRecord withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableToggleGroupCallRecord(this.identifier, value, this.start, this.video, this.call, this.title, this.videoPortrait);
    }

    public final ImmutableToggleGroupCallRecord withStart(boolean value) {
        if (this.start == value) {
            return this;
        }
        return new ImmutableToggleGroupCallRecord(this.identifier, this.flags, value, this.video, this.call, this.title, this.videoPortrait);
    }

    public final ImmutableToggleGroupCallRecord withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutableToggleGroupCallRecord(this.identifier, this.flags, this.start, value, this.call, this.title, this.videoPortrait);
    }

    public final ImmutableToggleGroupCallRecord withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableToggleGroupCallRecord(this.identifier, this.flags, this.start, this.video, newValue, this.title, this.videoPortrait);
    }

    public final ImmutableToggleGroupCallRecord withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableToggleGroupCallRecord(this.identifier, this.flags, this.start, this.video, this.call, value, this.videoPortrait);
    }

    public final ImmutableToggleGroupCallRecord withVideoPortrait(@Nullable Boolean value) {
        if (Objects.equals(this.videoPortrait, value)) {
            return this;
        }
        return new ImmutableToggleGroupCallRecord(this.identifier, this.flags, this.start, this.video, this.call, this.title, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleGroupCallRecord && this.equalTo(0, (ImmutableToggleGroupCallRecord)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleGroupCallRecord another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.start == another.start && this.video == another.video && this.call.equals(another.call) && Objects.equals(this.title, another.title) && Objects.equals(this.videoPortrait, another.videoPortrait);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.start);
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.videoPortrait);
        return h;
    }

    public String toString() {
        return "ToggleGroupCallRecord{identifier=" + this.identifier + ", flags=" + this.flags + ", start=" + this.start + ", video=" + this.video + ", call=" + this.call + ", title=" + this.title + ", videoPortrait=" + this.videoPortrait + "}";
    }

    public static ImmutableToggleGroupCallRecord of(InputGroupCall call) {
        return new ImmutableToggleGroupCallRecord(call);
    }

    public static ImmutableToggleGroupCallRecord copyOf(ToggleGroupCallRecord instance) {
        if (instance instanceof ImmutableToggleGroupCallRecord) {
            return (ImmutableToggleGroupCallRecord)instance;
        }
        return ImmutableToggleGroupCallRecord.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_START = 4L;
        private static final long OPT_BIT_VIDEO = 8L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean start;
        private boolean video;
        private InputGroupCall call;
        private String title;
        private Boolean videoPortrait;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToggleGroupCallRecord instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ToggleGroupCallRecord) {
                instance = (ToggleGroupCallRecord)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                this.start(instance.start());
                Boolean videoPortraitValue = instance.videoPortrait();
                if (videoPortraitValue != null) {
                    this.videoPortrait(videoPortraitValue);
                }
                this.video(instance.video());
                String titleValue = instance.title();
                if (titleValue != null) {
                    this.title(titleValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder start(boolean start) {
            this.start = start;
            this.optBits |= 4L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 8L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder videoPortrait(@Nullable Boolean videoPortrait) {
            this.videoPortrait = videoPortrait;
            return this;
        }

        public ImmutableToggleGroupCallRecord build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleGroupCallRecord(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean startIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build ToggleGroupCallRecord, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte startBuildStage = 0;
        private boolean start;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableToggleGroupCallRecord.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableToggleGroupCallRecord.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean start() {
            if (this.startBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startBuildStage == 0) {
                this.startBuildStage = (byte)-1;
                this.start = ImmutableToggleGroupCallRecord.this.startInitialize();
                this.startBuildStage = 1;
            }
            return this.start;
        }

        void start(boolean start) {
            this.start = start;
            this.startBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutableToggleGroupCallRecord.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.startBuildStage == -1) {
                attributes.add("start");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build ToggleGroupCallRecord, attribute initializers form cycle " + attributes;
        }
    }
}

