/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.ToggleGroupCallSettings;

public final class ImmutableToggleGroupCallSettings
implements ToggleGroupCallSettings {
    private final int identifier;
    private final int flags;
    private final boolean resetInviteHash;
    private final InputGroupCall call;
    @Nullable
    private final Boolean joinMuted;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableToggleGroupCallSettings(InputGroupCall call) {
        this.call = Objects.requireNonNull(call, "call");
        this.joinMuted = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.resetInviteHash = this.initShim.resetInviteHash();
        this.initShim = null;
    }

    private ImmutableToggleGroupCallSettings(Builder builder) {
        this.call = builder.call;
        this.joinMuted = builder.joinMuted;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.resetInviteHashIsSet()) {
            this.initShim.resetInviteHash(builder.resetInviteHash);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.resetInviteHash = this.initShim.resetInviteHash();
        this.initShim = null;
    }

    private ImmutableToggleGroupCallSettings(int identifier, int flags, boolean resetInviteHash, InputGroupCall call, @Nullable Boolean joinMuted) {
        this.identifier = identifier;
        this.flags = flags;
        this.resetInviteHash = resetInviteHash;
        this.call = call;
        this.joinMuted = joinMuted;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ToggleGroupCallSettings.super.identifier();
    }

    private int flagsInitialize() {
        return ToggleGroupCallSettings.super.flags();
    }

    private boolean resetInviteHashInitialize() {
        return ToggleGroupCallSettings.super.resetInviteHash();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean resetInviteHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.resetInviteHash() : this.resetInviteHash;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    @Nullable
    public Boolean joinMuted() {
        return this.joinMuted;
    }

    public final ImmutableToggleGroupCallSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleGroupCallSettings(value, this.flags, this.resetInviteHash, this.call, this.joinMuted);
    }

    public final ImmutableToggleGroupCallSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableToggleGroupCallSettings(this.identifier, value, this.resetInviteHash, this.call, this.joinMuted);
    }

    public final ImmutableToggleGroupCallSettings withResetInviteHash(boolean value) {
        if (this.resetInviteHash == value) {
            return this;
        }
        return new ImmutableToggleGroupCallSettings(this.identifier, this.flags, value, this.call, this.joinMuted);
    }

    public final ImmutableToggleGroupCallSettings withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableToggleGroupCallSettings(this.identifier, this.flags, this.resetInviteHash, newValue, this.joinMuted);
    }

    public final ImmutableToggleGroupCallSettings withJoinMuted(@Nullable Boolean value) {
        if (Objects.equals(this.joinMuted, value)) {
            return this;
        }
        return new ImmutableToggleGroupCallSettings(this.identifier, this.flags, this.resetInviteHash, this.call, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleGroupCallSettings && this.equalTo(0, (ImmutableToggleGroupCallSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleGroupCallSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.resetInviteHash == another.resetInviteHash && this.call.equals(another.call) && Objects.equals(this.joinMuted, another.joinMuted);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.resetInviteHash);
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + Objects.hashCode(this.joinMuted);
        return h;
    }

    public String toString() {
        return "ToggleGroupCallSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", resetInviteHash=" + this.resetInviteHash + ", call=" + this.call + ", joinMuted=" + this.joinMuted + "}";
    }

    public static ImmutableToggleGroupCallSettings of(InputGroupCall call) {
        return new ImmutableToggleGroupCallSettings(call);
    }

    public static ImmutableToggleGroupCallSettings copyOf(ToggleGroupCallSettings instance) {
        if (instance instanceof ImmutableToggleGroupCallSettings) {
            return (ImmutableToggleGroupCallSettings)instance;
        }
        return ImmutableToggleGroupCallSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_RESET_INVITE_HASH = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean resetInviteHash;
        private InputGroupCall call;
        private Boolean joinMuted;

        private Builder() {
        }

        public final Builder from(ToggleGroupCallSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToggleGroupCallSettings instance;
            long bits = 0L;
            if (object instanceof ToggleGroupCallSettings) {
                Boolean joinMutedValue;
                instance = (ToggleGroupCallSettings)object;
                this.call(instance.call());
                this.flags(instance.flags());
                this.resetInviteHash(instance.resetInviteHash());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((joinMutedValue = instance.joinMuted()) != null) {
                    this.joinMuted(joinMutedValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder resetInviteHash(boolean resetInviteHash) {
            this.resetInviteHash = resetInviteHash;
            this.optBits |= 4L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder joinMuted(@Nullable Boolean joinMuted) {
            this.joinMuted = joinMuted;
            return this;
        }

        public ImmutableToggleGroupCallSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleGroupCallSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean resetInviteHashIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build ToggleGroupCallSettings, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte resetInviteHashBuildStage = 0;
        private boolean resetInviteHash;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableToggleGroupCallSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableToggleGroupCallSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean resetInviteHash() {
            if (this.resetInviteHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resetInviteHashBuildStage == 0) {
                this.resetInviteHashBuildStage = (byte)-1;
                this.resetInviteHash = ImmutableToggleGroupCallSettings.this.resetInviteHashInitialize();
                this.resetInviteHashBuildStage = 1;
            }
            return this.resetInviteHash;
        }

        void resetInviteHash(boolean resetInviteHash) {
            this.resetInviteHash = resetInviteHash;
            this.resetInviteHashBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.resetInviteHashBuildStage == -1) {
                attributes.add("resetInviteHash");
            }
            return "Cannot build ToggleGroupCallSettings, attribute initializers form cycle " + attributes;
        }
    }
}

