/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.phone.ToggleGroupCallStartSubscription;

public final class ImmutableToggleGroupCallStartSubscription
implements ToggleGroupCallStartSubscription {
    private final int identifier;
    private final InputGroupCall call;
    private final boolean subscribed;

    private ImmutableToggleGroupCallStartSubscription(InputGroupCall call, boolean subscribed) {
        this.call = Objects.requireNonNull(call, "call");
        this.subscribed = subscribed;
        this.identifier = ToggleGroupCallStartSubscription.super.identifier();
    }

    private ImmutableToggleGroupCallStartSubscription(Builder builder) {
        this.call = builder.call;
        this.subscribed = builder.subscribed;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ToggleGroupCallStartSubscription.super.identifier();
    }

    private ImmutableToggleGroupCallStartSubscription(int identifier, InputGroupCall call, boolean subscribed) {
        this.identifier = identifier;
        this.call = call;
        this.subscribed = subscribed;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public boolean subscribed() {
        return this.subscribed;
    }

    public final ImmutableToggleGroupCallStartSubscription withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableToggleGroupCallStartSubscription(value, this.call, this.subscribed);
    }

    public final ImmutableToggleGroupCallStartSubscription withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableToggleGroupCallStartSubscription(this.identifier, newValue, this.subscribed);
    }

    public final ImmutableToggleGroupCallStartSubscription withSubscribed(boolean value) {
        if (this.subscribed == value) {
            return this;
        }
        return new ImmutableToggleGroupCallStartSubscription(this.identifier, this.call, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToggleGroupCallStartSubscription && this.equalTo(0, (ImmutableToggleGroupCallStartSubscription)another);
    }

    private boolean equalTo(int synthetic, ImmutableToggleGroupCallStartSubscription another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.subscribed == another.subscribed;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + Boolean.hashCode(this.subscribed);
        return h;
    }

    public String toString() {
        return "ToggleGroupCallStartSubscription{identifier=" + this.identifier + ", call=" + this.call + ", subscribed=" + this.subscribed + "}";
    }

    public static ImmutableToggleGroupCallStartSubscription of(InputGroupCall call, boolean subscribed) {
        return new ImmutableToggleGroupCallStartSubscription(call, subscribed);
    }

    public static ImmutableToggleGroupCallStartSubscription copyOf(ToggleGroupCallStartSubscription instance) {
        if (instance instanceof ImmutableToggleGroupCallStartSubscription) {
            return (ImmutableToggleGroupCallStartSubscription)instance;
        }
        return ImmutableToggleGroupCallStartSubscription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_SUBSCRIBED = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private boolean subscribed;

        private Builder() {
        }

        public final Builder from(ToggleGroupCallStartSubscription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToggleGroupCallStartSubscription instance;
            long bits = 0L;
            if (object instanceof ToggleGroupCallStartSubscription) {
                instance = (ToggleGroupCallStartSubscription)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.subscribed(instance.subscribed());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder subscribed(boolean subscribed) {
            this.subscribed = subscribed;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableToggleGroupCallStartSubscription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToggleGroupCallStartSubscription(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("subscribed");
            }
            return "Cannot build ToggleGroupCallStartSubscription, some of required attributes are not set " + attributes;
        }
    }
}

