/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.photos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPhoto;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.photos.DeletePhotos;

public final class ImmutableDeletePhotos
implements DeletePhotos {
    private final int identifier;
    private final List<InputPhoto> id;

    private ImmutableDeletePhotos(Builder builder) {
        this.id = ImmutableDeletePhotos.createUnmodifiableList(true, builder.id);
        this.identifier = builder.identifierIsSet() ? builder.identifier : DeletePhotos.super.identifier();
    }

    private ImmutableDeletePhotos(int identifier, List<InputPhoto> id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputPhoto> id() {
        return this.id;
    }

    public final ImmutableDeletePhotos withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeletePhotos(value, this.id);
    }

    public final ImmutableDeletePhotos withId(InputPhoto ... elements) {
        List<InputPhoto> newValue = ImmutableDeletePhotos.createUnmodifiableList(false, ImmutableDeletePhotos.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDeletePhotos(this.identifier, newValue);
    }

    public final ImmutableDeletePhotos withId(Iterable<? extends InputPhoto> elements) {
        if (this.id == elements) {
            return this;
        }
        List<InputPhoto> newValue = ImmutableDeletePhotos.createUnmodifiableList(false, ImmutableDeletePhotos.createSafeList(elements, true, false));
        return new ImmutableDeletePhotos(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeletePhotos && this.equalTo(0, (ImmutableDeletePhotos)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeletePhotos another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "DeletePhotos{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableDeletePhotos copyOf(DeletePhotos instance) {
        if (instance instanceof ImmutableDeletePhotos) {
            return (ImmutableDeletePhotos)instance;
        }
        return ImmutableDeletePhotos.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputPhoto> id = new ArrayList<InputPhoto>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeletePhotos instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DeletePhotos) {
                instance = (DeletePhotos)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllId(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addId(InputPhoto element) {
            this.id.add(Objects.requireNonNull(element, "id element"));
            return this;
        }

        public final Builder addId(InputPhoto ... elements) {
            for (InputPhoto element : elements) {
                this.id.add(Objects.requireNonNull(element, "id element"));
            }
            return this;
        }

        public final Builder id(Iterable<? extends InputPhoto> elements) {
            this.id.clear();
            return this.addAllId(elements);
        }

        public final Builder addAllId(Iterable<? extends InputPhoto> elements) {
            for (InputPhoto inputPhoto : elements) {
                this.id.add(Objects.requireNonNull(inputPhoto, "id element"));
            }
            return this;
        }

        public ImmutableDeletePhotos build() {
            return new ImmutableDeletePhotos(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

