/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.photos;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.photos.GetUserPhotos;

public final class ImmutableGetUserPhotos
implements GetUserPhotos {
    private final int identifier;
    private final InputUser userId;
    private final int offset;
    private final long maxId;
    private final int limit;

    private ImmutableGetUserPhotos(InputUser userId, int offset, long maxId, int limit) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.offset = offset;
        this.maxId = maxId;
        this.limit = limit;
        this.identifier = GetUserPhotos.super.identifier();
    }

    private ImmutableGetUserPhotos(Builder builder) {
        this.userId = builder.userId;
        this.offset = builder.offset;
        this.maxId = builder.maxId;
        this.limit = builder.limit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetUserPhotos.super.identifier();
    }

    private ImmutableGetUserPhotos(int identifier, InputUser userId, int offset, long maxId, int limit) {
        this.identifier = identifier;
        this.userId = userId;
        this.offset = offset;
        this.maxId = maxId;
        this.limit = limit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public long maxId() {
        return this.maxId;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ImmutableGetUserPhotos withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetUserPhotos(value, this.userId, this.offset, this.maxId, this.limit);
    }

    public final ImmutableGetUserPhotos withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableGetUserPhotos(this.identifier, newValue, this.offset, this.maxId, this.limit);
    }

    public final ImmutableGetUserPhotos withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableGetUserPhotos(this.identifier, this.userId, value, this.maxId, this.limit);
    }

    public final ImmutableGetUserPhotos withMaxId(long value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableGetUserPhotos(this.identifier, this.userId, this.offset, value, this.limit);
    }

    public final ImmutableGetUserPhotos withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableGetUserPhotos(this.identifier, this.userId, this.offset, this.maxId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetUserPhotos && this.equalTo(0, (ImmutableGetUserPhotos)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetUserPhotos another) {
        return this.identifier == another.identifier && this.userId.equals(another.userId) && this.offset == another.offset && this.maxId == another.maxId && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.offset;
        h += (h << 5) + Long.hashCode(this.maxId);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return "GetUserPhotos{identifier=" + this.identifier + ", userId=" + this.userId + ", offset=" + this.offset + ", maxId=" + this.maxId + ", limit=" + this.limit + "}";
    }

    public static ImmutableGetUserPhotos of(InputUser userId, int offset, long maxId, int limit) {
        return new ImmutableGetUserPhotos(userId, offset, maxId, limit);
    }

    public static ImmutableGetUserPhotos copyOf(GetUserPhotos instance) {
        if (instance instanceof ImmutableGetUserPhotos) {
            return (ImmutableGetUserPhotos)instance;
        }
        return ImmutableGetUserPhotos.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_OFFSET = 2L;
        private static final long INIT_BIT_MAX_ID = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputUser userId;
        private int offset;
        private long maxId;
        private int limit;

        private Builder() {
        }

        public final Builder from(GetUserPhotos instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetUserPhotos instance;
            long bits = 0L;
            if (object instanceof GetUserPhotos) {
                instance = (GetUserPhotos)object;
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.offset(instance.offset());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder maxId(long maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGetUserPhotos build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetUserPhotos(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build GetUserPhotos, some of required attributes are not set " + attributes;
        }
    }
}

