/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.photos;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoto;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.photos.UpdateProfilePhoto;

public final class ImmutableUpdateProfilePhoto
implements UpdateProfilePhoto {
    private final int identifier;
    private final InputPhoto id;

    private ImmutableUpdateProfilePhoto(InputPhoto id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = UpdateProfilePhoto.super.identifier();
    }

    private ImmutableUpdateProfilePhoto(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateProfilePhoto.super.identifier();
    }

    private ImmutableUpdateProfilePhoto(int identifier, InputPhoto id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPhoto id() {
        return this.id;
    }

    public final ImmutableUpdateProfilePhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateProfilePhoto(value, this.id);
    }

    public final ImmutableUpdateProfilePhoto withId(InputPhoto value) {
        if (this.id == value) {
            return this;
        }
        InputPhoto newValue = Objects.requireNonNull(value, "id");
        return new ImmutableUpdateProfilePhoto(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateProfilePhoto && this.equalTo(0, (ImmutableUpdateProfilePhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateProfilePhoto another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateProfilePhoto{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableUpdateProfilePhoto of(InputPhoto id) {
        return new ImmutableUpdateProfilePhoto(id);
    }

    public static ImmutableUpdateProfilePhoto copyOf(UpdateProfilePhoto instance) {
        if (instance instanceof ImmutableUpdateProfilePhoto) {
            return (ImmutableUpdateProfilePhoto)instance;
        }
        return ImmutableUpdateProfilePhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPhoto id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateProfilePhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateProfilePhoto) {
                instance = (UpdateProfilePhoto)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputPhoto id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateProfilePhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateProfilePhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build UpdateProfilePhoto, some of required attributes are not set " + attributes;
        }
    }
}

