/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.photos;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputFile;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.photos.UploadProfilePhoto;

public final class ImmutableUploadProfilePhoto
implements UploadProfilePhoto {
    private final int identifier;
    private final int flags;
    @Nullable
    private final InputFile file;
    @Nullable
    private final InputFile video;
    @Nullable
    private final Double videoStartTs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableUploadProfilePhoto INSTANCE = ImmutableUploadProfilePhoto.validate(new ImmutableUploadProfilePhoto());

    private ImmutableUploadProfilePhoto() {
        this.file = null;
        this.video = null;
        this.videoStartTs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUploadProfilePhoto(Builder builder) {
        this.file = builder.file;
        this.video = builder.video;
        this.videoStartTs = builder.videoStartTs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUploadProfilePhoto(int identifier, int flags, @Nullable InputFile file, @Nullable InputFile video, @Nullable Double videoStartTs) {
        this.identifier = identifier;
        this.flags = flags;
        this.file = file;
        this.video = video;
        this.videoStartTs = videoStartTs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UploadProfilePhoto.super.identifier();
    }

    private int flagsInitialize() {
        return UploadProfilePhoto.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public InputFile file() {
        return this.file;
    }

    @Override
    @Nullable
    public InputFile video() {
        return this.video;
    }

    @Override
    @Nullable
    public Double videoStartTs() {
        return this.videoStartTs;
    }

    public final ImmutableUploadProfilePhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUploadProfilePhoto.validate(new ImmutableUploadProfilePhoto(value, this.flags, this.file, this.video, this.videoStartTs));
    }

    public final ImmutableUploadProfilePhoto withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableUploadProfilePhoto.validate(new ImmutableUploadProfilePhoto(this.identifier, value, this.file, this.video, this.videoStartTs));
    }

    public final ImmutableUploadProfilePhoto withFile(@Nullable InputFile value) {
        if (this.file == value) {
            return this;
        }
        return ImmutableUploadProfilePhoto.validate(new ImmutableUploadProfilePhoto(this.identifier, this.flags, value, this.video, this.videoStartTs));
    }

    public final ImmutableUploadProfilePhoto withVideo(@Nullable InputFile value) {
        if (this.video == value) {
            return this;
        }
        return ImmutableUploadProfilePhoto.validate(new ImmutableUploadProfilePhoto(this.identifier, this.flags, this.file, value, this.videoStartTs));
    }

    public final ImmutableUploadProfilePhoto withVideoStartTs(@Nullable Double value) {
        if (Objects.equals(this.videoStartTs, value)) {
            return this;
        }
        return ImmutableUploadProfilePhoto.validate(new ImmutableUploadProfilePhoto(this.identifier, this.flags, this.file, this.video, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUploadProfilePhoto && this.equalTo(0, (ImmutableUploadProfilePhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableUploadProfilePhoto another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.file, another.file) && Objects.equals(this.video, another.video) && Objects.equals(this.videoStartTs, another.videoStartTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.file);
        h += (h << 5) + Objects.hashCode(this.video);
        h += (h << 5) + Objects.hashCode(this.videoStartTs);
        return h;
    }

    public String toString() {
        return "UploadProfilePhoto{identifier=" + this.identifier + ", flags=" + this.flags + ", file=" + this.file + ", video=" + this.video + ", videoStartTs=" + this.videoStartTs + "}";
    }

    public static ImmutableUploadProfilePhoto of() {
        return INSTANCE;
    }

    private static ImmutableUploadProfilePhoto validate(ImmutableUploadProfilePhoto instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUploadProfilePhoto copyOf(UploadProfilePhoto instance) {
        if (instance instanceof ImmutableUploadProfilePhoto) {
            return (ImmutableUploadProfilePhoto)instance;
        }
        return ImmutableUploadProfilePhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputFile file;
        private InputFile video;
        private Double videoStartTs;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UploadProfilePhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UploadProfilePhoto) {
                InputFile videoValue;
                Double videoStartTsValue;
                InputFile fileValue;
                instance = (UploadProfilePhoto)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((fileValue = instance.file()) != null) {
                    this.file(fileValue);
                }
                if ((videoStartTsValue = instance.videoStartTs()) != null) {
                    this.videoStartTs(videoStartTsValue);
                }
                if ((videoValue = instance.video()) != null) {
                    this.video(videoValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder file(@Nullable InputFile file) {
            this.file = file;
            return this;
        }

        public final Builder video(@Nullable InputFile video) {
            this.video = video;
            return this;
        }

        public final Builder videoStartTs(@Nullable Double videoStartTs) {
            this.videoStartTs = videoStartTs;
            return this;
        }

        public ImmutableUploadProfilePhoto build() {
            return ImmutableUploadProfilePhoto.validate(new ImmutableUploadProfilePhoto(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUploadProfilePhoto.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUploadProfilePhoto.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UploadProfilePhoto, attribute initializers form cycle " + attributes;
        }
    }
}

